/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.server.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.util.Lazy;
import org.eclipse.milo.opcua.stack.transport.server.OpcServerTransport;
import org.eclipse.milo.opcua.stack.transport.server.ServerApplicationContext;
import org.eclipse.milo.opcua.stack.transport.server.tcp.OpcTcpServerTransportConfig;
import org.eclipse.milo.opcua.stack.transport.server.tcp.RateLimitingHandler;
import org.eclipse.milo.opcua.stack.transport.server.uasc.UascServerHelloHandler;
import org.slf4j.LoggerFactory;

public class OpcTcpServerTransport
implements OpcServerTransport {
    private final Set<InetSocketAddress> boundAddresses = new HashSet<InetSocketAddress>();
    private final Set<Channel> channelReferences = new HashSet<Channel>();
    private final Set<Channel> childChannelReferences = Collections.synchronizedSet(new HashSet());
    private final Lazy<ServerBootstrap> serverBootstrap = new Lazy();
    private final OpcTcpServerTransportConfig config;

    public OpcTcpServerTransport(OpcTcpServerTransportConfig config) {
        this.config = config;
    }

    @Override
    public synchronized void bind(final ServerApplicationContext applicationContext, InetSocketAddress bindAddress) throws Exception {
        ServerBootstrap bootstrap = (ServerBootstrap)this.serverBootstrap.get(() -> ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(NioServerSocketChannel.class)).group(this.config.getEventLoop()).handler((ChannelHandler)new LoggingHandler(OpcTcpServerTransport.class))).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{RateLimitingHandler.getInstance()});
                channel.pipeline().addLast(new ChannelHandler[]{new UascServerHelloHandler(OpcTcpServerTransport.this.config, applicationContext, TransportProfile.TCP_UASC_UABINARY)});
                OpcTcpServerTransport.this.config.getChannelPipelineCustomizer().accept(channel.pipeline());
                OpcTcpServerTransport.this.childChannelReferences.add((Channel)channel);
                channel.closeFuture().addListener(future -> OpcTcpServerTransport.this.childChannelReferences.remove(channel));
            }
        }));
        assert (bootstrap != null);
        this.config.getBootstrapCustomizer().accept(bootstrap);
        if (!this.boundAddresses.contains(bindAddress)) {
            ChannelFuture bindFuture = bootstrap.bind((SocketAddress)bindAddress).sync();
            this.boundAddresses.add(bindAddress);
            this.channelReferences.add(bindFuture.channel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unbind() {
        this.boundAddresses.clear();
        this.channelReferences.forEach(channel -> {
            try {
                channel.close().sync();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.channelReferences.clear();
        Set<Channel> set = this.childChannelReferences;
        synchronized (set) {
            this.childChannelReferences.forEach(channel -> {
                LoggerFactory.getLogger(this.getClass()).info("Closing child channel: {}", channel);
                channel.close();
            });
            this.childChannelReferences.clear();
        }
        this.serverBootstrap.reset();
    }
}

