/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.client.uasc;

import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.UaResponseMessageType;
import org.jspecify.annotations.Nullable;

public final class UascResponse {
    private final long requestId;
    private final UaResponseMessageType responseMessage;
    private final UaException exception;

    private UascResponse(long requestId, @Nullable UaResponseMessageType responseMessage, @Nullable UaException exception) {
        this.requestId = requestId;
        this.responseMessage = responseMessage;
        this.exception = exception;
        assert (responseMessage == null || exception == null);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public @Nullable UaResponseMessageType getResponseMessage() {
        return this.responseMessage;
    }

    public @Nullable UaException getException() {
        return this.exception;
    }

    public boolean isSuccess() {
        return this.responseMessage != null;
    }

    public boolean isFailure() {
        return this.exception != null;
    }

    public static UascResponse success(long requestId, UaResponseMessageType responseMessage) {
        return new UascResponse(requestId, responseMessage, null);
    }

    public static UascResponse failure(long requestId, UaException exception) {
        return new UascResponse(requestId, null, exception);
    }
}

