/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.client.uasc;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.Timeout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.channel.messages.AcknowledgeMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.HelloMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.transport.client.ClientApplicationContext;
import org.eclipse.milo.opcua.stack.transport.client.uasc.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.transport.client.uasc.UascClientConfig;
import org.eclipse.milo.opcua.stack.transport.client.uasc.UascClientMessageHandler;
import org.eclipse.milo.shaded.com.google.common.primitives.Ints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UascClientAcknowledgeHandler
extends ByteToMessageCodec<UaRequestMessageType> {
    private static final long PROTOCOL_VERSION = 0L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final List<UaRequestMessageType> awaitingHandshake = Collections.synchronizedList(new ArrayList());
    private final AtomicBoolean helloSent = new AtomicBoolean(false);
    private Timeout helloTimeout;
    private final UascClientConfig config;
    private final ClientApplicationContext application;
    private final Supplier<Long> requestIdSupplier;
    private final CompletableFuture<ClientSecureChannel> handshakeFuture;

    public UascClientAcknowledgeHandler(UascClientConfig config, ClientApplicationContext application, Supplier<Long> requestIdSupplier, CompletableFuture<ClientSecureChannel> handshakeFuture) {
        this.config = config;
        this.application = application;
        this.requestIdSupplier = requestIdSupplier;
        this.handshakeFuture = handshakeFuture;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.helloSent.compareAndSet(false, true)) {
            this.sendHello(ctx);
        }
        super.channelActive(ctx);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive() && this.helloSent.compareAndSet(false, true)) {
            this.sendHello(ctx);
        }
        super.handlerAdded(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.error("[remote={}] Exception caught: {}", new Object[]{ctx.channel().remoteAddress(), cause.getMessage(), cause});
        this.handshakeFuture.completeExceptionally(cause);
        ctx.close();
    }

    private void sendHello(ChannelHandlerContext ctx) throws UaException {
        this.helloTimeout = this.startHelloTimeout(ctx);
        String endpointUrl = this.application.getEndpoint().getEndpointUrl();
        EncodingLimits encodingLimits = this.application.getEncodingContext().getEncodingLimits();
        HelloMessage hello = new HelloMessage(0L, (long)encodingLimits.getMaxChunkSize(), (long)encodingLimits.getMaxChunkSize(), (long)encodingLimits.getMaxMessageSize(), (long)encodingLimits.getMaxChunkCount(), endpointUrl);
        ByteBuf messageBuffer = TcpMessageEncoder.encode((HelloMessage)hello);
        ctx.writeAndFlush((Object)messageBuffer, ctx.voidPromise());
        this.logger.debug("Sent Hello message on channel={}.", (Object)ctx.channel());
    }

    private Timeout startHelloTimeout(ChannelHandlerContext ctx) {
        long acknowledgeTimeoutMs = this.config.getAcknowledgeTimeout().longValue();
        return this.config.getWheelTimer().newTimeout(timeout -> {
            if (!timeout.isCancelled()) {
                this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for acknowledge"));
                ctx.close();
            }
        }, acknowledgeTimeoutMs, TimeUnit.MILLISECONDS);
    }

    protected void encode(ChannelHandlerContext ctx, UaRequestMessageType message, ByteBuf byteBuf) throws Exception {
        this.awaitingHandshake.add(message);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> list) throws Exception {
        int maxChunkSize = this.application.getEncodingContext().getEncodingLimits().getMaxChunkSize();
        if (buffer.readableBytes() >= 8) {
            int messageLength = UascClientAcknowledgeHandler.getMessageLength(buffer, maxChunkSize);
            if (buffer.readableBytes() >= messageLength) {
                MessageType messageType = MessageType.fromMediumInt((int)buffer.getMediumLE(buffer.readerIndex()));
                switch (messageType) {
                    case Acknowledge: {
                        this.onAcknowledge(ctx, buffer.readSlice(messageLength));
                        break;
                    }
                    case Error: {
                        this.onError(ctx, buffer.readSlice(messageLength));
                        break;
                    }
                    default: {
                        ctx.fireChannelRead((Object)buffer.readRetainedSlice(messageLength));
                    }
                }
            }
        }
    }

    private void onAcknowledge(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (this.helloTimeout != null && !this.helloTimeout.cancel()) {
            this.helloTimeout = null;
            this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for acknowledge"));
            ctx.close();
            return;
        }
        this.logger.debug("Received Acknowledge message on channel={}.", (Object)ctx.channel());
        buffer.skipBytes(8);
        AcknowledgeMessage acknowledge = AcknowledgeMessage.decode((ByteBuf)buffer);
        long remoteProtocolVersion = acknowledge.getProtocolVersion();
        long remoteReceiveBufferSize = acknowledge.getReceiveBufferSize();
        long remoteSendBufferSize = acknowledge.getSendBufferSize();
        long remoteMaxMessageSize = acknowledge.getMaxMessageSize();
        long remoteMaxChunkCount = acknowledge.getMaxChunkCount();
        if (0L > remoteProtocolVersion) {
            this.logger.warn("Client protocol version ({}) does not match server protocol version ({}).", (Object)0L, (Object)remoteProtocolVersion);
        }
        EncodingLimits encodingLimits = this.application.getEncodingContext().getEncodingLimits();
        long localReceiveBufferSize = Math.min(remoteSendBufferSize, (long)encodingLimits.getMaxChunkSize());
        long localSendBufferSize = Math.min(remoteReceiveBufferSize, (long)encodingLimits.getMaxChunkSize());
        long localMaxMessageSize = encodingLimits.getMaxMessageSize();
        long localMaxChunkCount = encodingLimits.getMaxChunkCount();
        ChannelParameters channelParameters = new ChannelParameters(Ints.saturatedCast((long)localMaxMessageSize), Ints.saturatedCast((long)localReceiveBufferSize), Ints.saturatedCast((long)localSendBufferSize), Ints.saturatedCast((long)localMaxChunkCount), Ints.saturatedCast((long)remoteMaxMessageSize), Ints.saturatedCast((long)remoteReceiveBufferSize), Ints.saturatedCast((long)remoteSendBufferSize), Ints.saturatedCast((long)remoteMaxChunkCount));
        ctx.executor().execute(() -> {
            UascClientMessageHandler messageHandler = new UascClientMessageHandler(this.config, this.application, this.requestIdSupplier, this.handshakeFuture, this.awaitingHandshake, channelParameters);
            ctx.pipeline().addFirst(new ChannelHandler[]{messageHandler});
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            ErrorMessage errorMessage = TcpMessageDecoder.decodeError((ByteBuf)buffer);
            StatusCode statusCode = errorMessage.getError();
            this.logger.error("[remote={}] received error message: {}", (Object)ctx.channel().remoteAddress(), (Object)errorMessage);
            this.handshakeFuture.completeExceptionally(new UaException(statusCode, errorMessage.getReason()));
            ctx.fireUserEventTriggered((Object)errorMessage);
        }
        catch (UaException e) {
            this.logger.error("[remote={}] an exception occurred while decoding an error message: {}", new Object[]{ctx.channel().remoteAddress(), e.getMessage(), e});
            this.handshakeFuture.completeExceptionally(e);
        }
        finally {
            ctx.close();
        }
    }

    private static int getMessageLength(ByteBuf buffer, int maxMessageLength) throws UaException {
        long messageLength = buffer.getUnsignedIntLE(buffer.readerIndex() + 4);
        if (messageLength <= (long)maxMessageLength) {
            return (int)messageLength;
        }
        throw new UaException(0x80800000L, String.format("max message length exceeded (%s > %s)", messageLength, maxMessageLength));
    }
}

