/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.client.uasc;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaServiceFaultException;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.types.UaResponseMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.transport.client.uasc.UascResponse;
import org.eclipse.milo.opcua.stack.transport.client.uasc.UascResponseHandler;

public abstract class InboundUascResponseHandler
extends SimpleChannelInboundHandler<UascResponse>
implements UascResponseHandler {
    protected void channelRead0(ChannelHandlerContext ctx, UascResponse response) {
        if (response.isSuccess()) {
            UaResponseMessageType responseMessage = response.getResponseMessage();
            assert (responseMessage != null);
            ResponseHeader responseHeader = responseMessage.getResponseHeader();
            if (responseHeader.getServiceResult().isGood()) {
                this.handleResponse(response.getRequestId(), responseMessage);
            } else {
                ServiceFault serviceFault = responseMessage instanceof ServiceFault ? (ServiceFault)responseMessage : new ServiceFault(responseHeader);
                this.handleReceiveFailure(response.getRequestId(), (UaException)new UaServiceFaultException(serviceFault));
            }
        } else {
            this.handleReceiveFailure(response.getRequestId(), response.getException());
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof UascResponse) {
            UascResponse response = (UascResponse)evt;
            assert (response.isFailure());
            this.handleSendFailure(response.getRequestId(), response.getException());
        } else if (evt instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)evt;
            StatusCode statusCode = errorMessage.getError();
            this.handleChannelError(new UaException(statusCode, errorMessage.getReason()));
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.handleChannelInactive();
        super.channelInactive(ctx);
    }

    public static class DelegatingUascResponseHandler
    extends InboundUascResponseHandler {
        private final UascResponseHandler delegate;

        public DelegatingUascResponseHandler(UascResponseHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void handleResponse(long requestId, UaResponseMessageType responseMessage) {
            this.delegate.handleResponse(requestId, responseMessage);
        }

        @Override
        public void handleSendFailure(long requestId, UaException exception) {
            this.delegate.handleSendFailure(requestId, exception);
        }

        @Override
        public void handleReceiveFailure(long requestId, UaException exception) {
            this.delegate.handleReceiveFailure(requestId, exception);
        }

        @Override
        public void handleChannelError(UaException exception) {
            this.delegate.handleChannelError(exception);
        }

        @Override
        public void handleChannelInactive() {
            this.delegate.handleChannelInactive();
        }
    }
}

