/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.client.uasc;

import io.netty.channel.Channel;
import io.netty.util.DefaultAttributeMap;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.shaded.com.google.common.base.MoreObjects;

public class ClientSecureChannel
extends DefaultAttributeMap
implements SecureChannel {
    private volatile Channel channel;
    private volatile long channelId = 0L;
    private volatile ChannelSecurity channelSecurity;
    private volatile ByteString localNonce = ByteString.NULL_VALUE;
    private volatile ByteString remoteNonce = ByteString.NULL_VALUE;
    private final KeyPair keyPair;
    private final X509Certificate localCertificate;
    private final List<X509Certificate> localCertificateChain;
    private final X509Certificate remoteCertificate;
    private final List<X509Certificate> remoteCertificateChain;
    private final SecurityPolicy securityPolicy;
    private final MessageSecurityMode messageSecurityMode;

    public ClientSecureChannel(SecurityPolicy securityPolicy, MessageSecurityMode messageSecurityMode) {
        this(null, null, null, null, null, securityPolicy, messageSecurityMode);
    }

    public ClientSecureChannel(KeyPair keyPair, X509Certificate localCertificate, List<X509Certificate> localCertificateChain, X509Certificate remoteCertificate, List<X509Certificate> remoteCertificateChain, SecurityPolicy securityPolicy, MessageSecurityMode messageSecurityMode) {
        this.keyPair = keyPair;
        this.localCertificate = localCertificate;
        this.localCertificateChain = localCertificateChain;
        this.remoteCertificate = remoteCertificate;
        this.remoteCertificateChain = remoteCertificateChain;
        this.securityPolicy = securityPolicy;
        this.messageSecurityMode = messageSecurityMode;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setChannelId(long channelId) {
        this.channelId = channelId;
    }

    public void setChannelSecurity(ChannelSecurity channelSecurity) {
        this.channelSecurity = channelSecurity;
    }

    public void setLocalNonce(ByteString localNonce) {
        this.localNonce = localNonce;
    }

    public void setRemoteNonce(ByteString remoteNonce) {
        this.remoteNonce = remoteNonce;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public long getChannelId() {
        return this.channelId;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public ByteString getLocalNonce() {
        return this.localNonce;
    }

    public ByteString getRemoteNonce() {
        return this.remoteNonce;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.messageSecurityMode;
    }

    public X509Certificate getLocalCertificate() {
        return this.localCertificate;
    }

    public List<X509Certificate> getLocalCertificateChain() {
        return this.localCertificateChain;
    }

    public X509Certificate getRemoteCertificate() {
        return this.remoteCertificate;
    }

    public List<X509Certificate> getRemoteCertificateChain() {
        return this.remoteCertificateChain;
    }

    public ChannelSecurity getChannelSecurity() {
        return this.channelSecurity;
    }

    public ChannelSecurity.SecretKeys getEncryptionKeys(ChannelSecurity.SecurityKeys securityKeys) {
        return securityKeys.getClientKeys();
    }

    public ChannelSecurity.SecretKeys getDecryptionKeys(ChannelSecurity.SecurityKeys securityKeys) {
        return securityKeys.getServerKeys();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("channelId", this.channelId).add("securityPolicy", (Object)this.securityPolicy).toString();
    }
}

