/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.client.tcp;

import com.digitalpetri.fsm.FsmContext;
import com.digitalpetri.netty.fsm.ChannelActions;
import com.digitalpetri.netty.fsm.ChannelFsm;
import com.digitalpetri.netty.fsm.ChannelFsmConfig;
import com.digitalpetri.netty.fsm.ChannelFsmFactory;
import com.digitalpetri.netty.fsm.Event;
import com.digitalpetri.netty.fsm.State;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.eclipse.milo.opcua.stack.transport.client.AbstractUascClientTransport;
import org.eclipse.milo.opcua.stack.transport.client.ClientApplicationContext;
import org.eclipse.milo.opcua.stack.transport.client.tcp.OpcTcpClientTransportConfig;
import org.eclipse.milo.opcua.stack.transport.client.uasc.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.transport.client.uasc.InboundUascResponseHandler;
import org.eclipse.milo.opcua.stack.transport.client.uasc.UascClientAcknowledgeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class OpcTcpClientTransport
extends AbstractUascClientTransport {
    private static final FsmContext.Key<ClientApplicationContext> KEY_CLIENT_APPLICATION = new FsmContext.Key("clientApplication", ClientApplicationContext.class);
    private static final String CHANNEL_FSM_LOGGER_NAME = "org.eclipse.milo.opcua.stack.client.ChannelFsm";
    private static final AtomicLong INSTANCE_ID = new AtomicLong();
    private final String instanceId;
    private final ChannelFsm channelFsm;
    private final OpcTcpClientTransportConfig config;

    public OpcTcpClientTransport(OpcTcpClientTransportConfig config) {
        super(config);
        this.config = config;
        this.instanceId = String.valueOf(INSTANCE_ID.incrementAndGet());
        ChannelFsmConfig fsmConfig = ChannelFsmConfig.newBuilder().setLazy(false).setMaxIdleSeconds(0).setMaxReconnectDelaySeconds(16).setPersistent(true).setChannelActions((ChannelActions)new ClientChannelActions()).setExecutor((Executor)config.getExecutor()).setScheduler(config.getScheduledExecutor()).setLoggerName(CHANNEL_FSM_LOGGER_NAME).setLoggingContext(Map.of("instance-id", this.instanceId)).build();
        ChannelFsmFactory factory = new ChannelFsmFactory(fsmConfig);
        this.channelFsm = factory.newChannelFsm();
    }

    @Override
    public OpcTcpClientTransportConfig getConfig() {
        return this.config;
    }

    @Override
    public CompletableFuture<Unit> connect(ClientApplicationContext applicationContext) {
        this.channelFsm.getFsm().withContext(ctx -> ctx.set(KEY_CLIENT_APPLICATION, (Object)applicationContext));
        return this.channelFsm.connect().thenApply(c -> Unit.VALUE);
    }

    @Override
    public CompletableFuture<Unit> disconnect() {
        return this.channelFsm.disconnect().thenApply(v -> Unit.VALUE);
    }

    @Override
    protected CompletableFuture<Channel> getChannel() {
        return this.channelFsm.getChannel();
    }

    public ChannelFsm getChannelFsm() {
        return this.channelFsm;
    }

    private class ClientChannelActions
    implements ChannelActions {
        private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.milo.opcua.stack.client.ChannelFsm");

        private ClientChannelActions() {
        }

        public CompletableFuture<Channel> connect(FsmContext<State, Event> ctx) {
            final ClientApplicationContext application = (ClientApplicationContext)ctx.get(KEY_CLIENT_APPLICATION);
            final CompletableFuture handshakeFuture = new CompletableFuture();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.channel(NioSocketChannel.class)).group(OpcTcpClientTransport.this.config.getEventLoop())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)OpcTcpClientTransport.this.config.getConnectTimeout().intValue())).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    UascClientAcknowledgeHandler acknowledgeHandler = new UascClientAcknowledgeHandler(OpcTcpClientTransport.this.config, application, OpcTcpClientTransport.this.requestId::getAndIncrement, handshakeFuture);
                    ch.pipeline().addLast(new ChannelHandler[]{new InboundUascResponseHandler.DelegatingUascResponseHandler(OpcTcpClientTransport.this)});
                    ch.pipeline().addLast(new ChannelHandler[]{acknowledgeHandler});
                    OpcTcpClientTransport.this.config.getChannelPipelineCustomizer().accept(ch.pipeline());
                }
            });
            OpcTcpClientTransport.this.config.getBootstrapCustomizer().accept(bootstrap);
            String endpointUrl = application.getEndpoint().getEndpointUrl();
            String host = EndpointUtil.getHost((String)endpointUrl);
            assert (host != null);
            int port = EndpointUtil.getPort((String)endpointUrl);
            bootstrap.connect(host, port).addListener(f -> {
                if (!f.isSuccess()) {
                    Throwable cause = f.cause();
                    if (cause instanceof ConnectTimeoutException) {
                        handshakeFuture.completeExceptionally(new UaException(0x800A0000L, f.cause()));
                    } else if (cause instanceof ConnectException) {
                        handshakeFuture.completeExceptionally(new UaException(2158755840L, f.cause()));
                    } else {
                        handshakeFuture.completeExceptionally(cause);
                    }
                }
            });
            return handshakeFuture.thenApply(ClientSecureChannel::getChannel);
        }

        public CompletableFuture<Void> disconnect(FsmContext<State, Event> ctx, Channel channel) {
            final CompletableFuture<Void> disconnectFuture = new CompletableFuture<Void>();
            TimerTask onTimeout = t -> channel.close().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> disconnectFuture.complete(null)));
            final Timeout timeout = OpcTcpClientTransport.this.config.getWheelTimer().newTimeout(onTimeout, 5L, TimeUnit.SECONDS);
            channel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelInactive(ChannelHandlerContext channelContext) throws Exception {
                    try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"instance-id", (String)OpcTcpClientTransport.this.instanceId);){
                        ClientChannelActions.this.logger.debug("channelInactive() disconnect complete");
                    }
                    timeout.cancel();
                    disconnectFuture.complete(null);
                    super.channelInactive(channelContext);
                }
            }});
            RequestHeader requestHeader = new RequestHeader(NodeId.NULL_VALUE, DateTime.now(), Unsigned.uint((int)0), Unsigned.uint((int)0), null, Unsigned.uint((int)0), null);
            try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"instance-id", (String)OpcTcpClientTransport.this.instanceId);){
                this.logger.debug("Sending CloseSecureChannelRequest...");
            }
            channel.pipeline().fireUserEventTriggered((Object)new CloseSecureChannelRequest(requestHeader));
            return disconnectFuture;
        }
    }
}

