/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.client;

import io.netty.channel.Channel;
import io.netty.util.Timeout;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.UaResponseMessageType;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;
import org.eclipse.milo.opcua.stack.transport.client.OpcClientTransport;
import org.eclipse.milo.opcua.stack.transport.client.OpcClientTransportConfig;
import org.eclipse.milo.opcua.stack.transport.client.uasc.UascRequest;
import org.eclipse.milo.opcua.stack.transport.client.uasc.UascResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUascClientTransport
implements OpcClientTransport,
UascResponseHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final AtomicLong requestId = new AtomicLong(1L);
    protected final Map<Long, CompletableFuture<UaResponseMessageType>> pendingRequests = new ConcurrentHashMap<Long, CompletableFuture<UaResponseMessageType>>();
    protected final Map<Long, Timeout> pendingTimeouts = new ConcurrentHashMap<Long, Timeout>();
    protected final ExecutionQueue publishResponseQueue;
    protected final OpcClientTransportConfig config;

    public AbstractUascClientTransport(OpcClientTransportConfig config) {
        this.config = config;
        this.publishResponseQueue = new ExecutionQueue((Executor)config.getExecutor());
    }

    protected abstract CompletableFuture<Channel> getChannel();

    @Override
    public CompletableFuture<UaResponseMessageType> sendRequestMessage(UaRequestMessageType requestMessage) {
        return this.getChannel().thenCompose(ch -> this.sendRequestMessage(requestMessage, (Channel)ch));
    }

    protected CompletableFuture<UaResponseMessageType> sendRequestMessage(UaRequestMessageType requestMessage, Channel channel) {
        UascRequest request = new UascRequest(this.requestId.getAndIncrement(), requestMessage);
        CompletableFuture<UaResponseMessageType> responseFuture = new CompletableFuture<UaResponseMessageType>();
        this.pendingRequests.put(request.getRequestId(), responseFuture);
        this.scheduleRequestTimeout(request);
        channel.writeAndFlush((Object)request).addListener(f -> {
            if (!f.isSuccess()) {
                this.pendingRequests.remove(request.getRequestId());
                this.cancelRequestTimeout(request.getRequestId());
                responseFuture.completeExceptionally(f.cause());
                this.logger.debug("Write failed, request={}, requestHandle={}", (Object)requestMessage.getClass().getSimpleName(), (Object)request.getRequestId());
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("Write succeeded, request={}, requestId={}", (Object)requestMessage.getClass().getSimpleName(), (Object)request.getRequestId());
            }
        });
        return responseFuture;
    }

    private void scheduleRequestTimeout(UascRequest request) {
        long timeoutHint;
        RequestHeader requestHeader = request.getRequestMessage().getRequestHeader();
        long l = timeoutHint = requestHeader.getTimeoutHint() != null ? requestHeader.getTimeoutHint().longValue() : 0L;
        if (timeoutHint > 0L) {
            Timeout timeout = this.config.getWheelTimer().newTimeout(t -> {
                CompletableFuture<UaResponseMessageType> future;
                Timeout removed = this.pendingTimeouts.remove(request.getRequestId());
                if (removed != null && !removed.isCancelled() && (future = this.pendingRequests.remove(request.getRequestId())) != null) {
                    UaException exception = new UaException(0x800A0000L, String.format("requestId=%s timed out after %sms", request.getRequestId(), timeoutHint));
                    future.completeExceptionally(exception);
                }
            }, timeoutHint, TimeUnit.MILLISECONDS);
            this.pendingTimeouts.put(request.getRequestId(), timeout);
        }
    }

    protected void cancelRequestTimeout(long requestId) {
        Timeout timeout = this.pendingTimeouts.remove(requestId);
        if (timeout != null) {
            timeout.cancel();
        }
    }

    @Override
    public void handleResponse(long requestId, UaResponseMessageType responseMessage) {
        CompletableFuture<UaResponseMessageType> responseFuture = this.pendingRequests.remove(requestId);
        if (responseFuture != null) {
            this.cancelRequestTimeout(requestId);
            if (responseMessage instanceof PublishResponse) {
                this.publishResponseQueue.submit(() -> responseFuture.complete(responseMessage));
            } else {
                this.config.getExecutor().execute(() -> responseFuture.complete(responseMessage));
            }
        } else {
            this.logger.warn("Received response for unknown request, requestId={}", (Object)requestId);
        }
    }

    @Override
    public void handleSendFailure(long requestId, UaException exception) {
        CompletableFuture<UaResponseMessageType> responseFuture = this.pendingRequests.remove(requestId);
        if (responseFuture != null) {
            this.cancelRequestTimeout(requestId);
            this.config.getExecutor().execute(() -> responseFuture.completeExceptionally(exception));
        } else {
            this.logger.warn("Send failed for unknown request, requestId={}", (Object)requestId);
        }
    }

    @Override
    public void handleReceiveFailure(long requestId, UaException exception) {
        CompletableFuture<UaResponseMessageType> responseFuture = this.pendingRequests.remove(requestId);
        if (responseFuture != null) {
            this.cancelRequestTimeout(requestId);
            this.config.getExecutor().execute(() -> responseFuture.completeExceptionally(exception));
        } else {
            this.logger.warn("Receive failed for unknown request, requestId={}", (Object)requestId);
        }
    }

    @Override
    public void handleChannelError(UaException exception) {
        this.failAndClearPending(exception);
    }

    @Override
    public void handleChannelInactive() {
        this.failAndClearPending(new UaException(2158886912L, "connection closed"));
    }

    private void failAndClearPending(UaException exception) {
        this.pendingRequests.forEach((requestId, f) -> {
            this.cancelRequestTimeout((long)requestId);
            this.config.getExecutor().execute(() -> f.completeExceptionally(exception));
        });
        this.pendingRequests.clear();
    }
}

