/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class HostnameUtil {
    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static Set<String> getHostnames(String address) {
        return HostnameUtil.getHostnames(address, true);
    }

    public static Set<String> getHostnames(String address, boolean includeLoopback) {
        return HostnameUtil.getHostnames(address, includeLoopback, true);
    }

    public static Set<String> getHostnames(String address, boolean includeLoopback, boolean resolveHostNames) {
        HashSet<String> hostnames;
        block8: {
            hostnames = new HashSet<String>();
            try {
                InetAddress inetAddress = InetAddress.getByName(address);
                if (inetAddress.isAnyLocalAddress()) {
                    try {
                        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                        for (NetworkInterface ni : Collections.list(nis)) {
                            Collections.list(ni.getInetAddresses()).forEach(ia -> {
                                if (ia instanceof Inet4Address && (includeLoopback || !ia.isLoopbackAddress())) {
                                    hostnames.add(ia.getHostAddress());
                                    if (resolveHostNames) {
                                        hostnames.add(ia.getHostName());
                                        hostnames.add(ia.getCanonicalHostName());
                                    }
                                }
                            });
                        }
                        break block8;
                    }
                    catch (SocketException e) {
                        LoggerFactory.getLogger(HostnameUtil.class).warn("Failed to NetworkInterfaces for bind address: {}", (Object)address, (Object)e);
                        break block8;
                    }
                }
                if (includeLoopback || !inetAddress.isLoopbackAddress()) {
                    hostnames.add(inetAddress.getHostAddress());
                    if (resolveHostNames) {
                        hostnames.add(inetAddress.getHostName());
                        hostnames.add(inetAddress.getCanonicalHostName());
                    }
                }
            }
            catch (UnknownHostException e) {
                LoggerFactory.getLogger(HostnameUtil.class).warn("Failed to get InetAddress for bind address: {}", (Object)address, (Object)e);
            }
        }
        return hostnames;
    }
}

