/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.lang.reflect.Array;
import java.util.Objects;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.Matrix;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DataChangeTrigger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DeadbandType;
import org.eclipse.milo.opcua.stack.core.types.structured.DataChangeFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DataChangeMonitoringFilter {
    public static boolean filter(@Nullable DataValue lastValue, DataValue currentValue, DataChangeFilter filter) {
        return DataChangeMonitoringFilter.triggerFilter(lastValue, currentValue, filter, null);
    }

    public static boolean filter(@Nullable DataValue lastValue, DataValue currentValue, DataChangeFilter filter, @Nullable Range euRange) {
        return DataChangeMonitoringFilter.triggerFilter(lastValue, currentValue, filter, euRange);
    }

    private static boolean triggerFilter(@Nullable DataValue lastValue, DataValue currentValue, DataChangeFilter filter, @Nullable Range euRange) {
        if (lastValue == null) {
            return true;
        }
        DataChangeTrigger trigger = filter.getTrigger();
        return switch (trigger) {
            default -> throw new IncompatibleClassChangeError();
            case DataChangeTrigger.Status -> DataChangeMonitoringFilter.filterByStatus(lastValue, currentValue);
            case DataChangeTrigger.StatusValue -> DataChangeMonitoringFilter.filterByStatusValue(lastValue, currentValue, filter, euRange);
            case DataChangeTrigger.StatusValueTimestamp -> DataChangeMonitoringFilter.filterByStatusValueTimestamp(lastValue, currentValue, filter, euRange);
        };
    }

    private static boolean filterByStatus(DataValue lastValue, DataValue currentValue) {
        return DataChangeMonitoringFilter.statusChanged(lastValue, currentValue);
    }

    private static boolean filterByStatusValue(DataValue lastValue, DataValue currentValue, DataChangeFilter filter, @Nullable Range euRange) {
        return DataChangeMonitoringFilter.deadbandFilter(lastValue, currentValue, filter, euRange) || DataChangeMonitoringFilter.statusChanged(lastValue, currentValue);
    }

    private static boolean filterByStatusValueTimestamp(DataValue lastValue, DataValue currentValue, DataChangeFilter filter, @Nullable Range euRange) {
        if (DeadbandType.from((int)filter.getDeadbandType().intValue()) != DeadbandType.None) {
            return DataChangeMonitoringFilter.deadbandFilter(lastValue, currentValue, filter, euRange) || DataChangeMonitoringFilter.statusChanged(lastValue, currentValue);
        }
        return DataChangeMonitoringFilter.timestampChanged(lastValue, currentValue) || DataChangeMonitoringFilter.deadbandFilter(lastValue, currentValue, filter, euRange) || DataChangeMonitoringFilter.statusChanged(lastValue, currentValue);
    }

    private static boolean deadbandFilter(@Nullable DataValue lastValue, DataValue currentValue, DataChangeFilter filter, @Nullable Range euRange) {
        if (lastValue == null) {
            return true;
        }
        int index = filter.getDeadbandType().intValue();
        if (index < 0 || index >= DeadbandType.values().length) {
            return true;
        }
        DeadbandType deadbandType = DeadbandType.values()[index];
        if (deadbandType == DeadbandType.None) {
            return DataChangeMonitoringFilter.valueChanged(lastValue, currentValue);
        }
        Object last = lastValue.value().value();
        Object current = currentValue.value().value();
        if (last == null || current == null) {
            return DataChangeMonitoringFilter.valueChanged(lastValue, currentValue);
        }
        if (DataChangeMonitoringFilter.getValueType(last) != DataChangeMonitoringFilter.getValueType(current)) {
            return true;
        }
        if (last instanceof Matrix) {
            Matrix lastMatrix = (Matrix)last;
            if (current instanceof Matrix) {
                Matrix currentMatrix = (Matrix)current;
                Object lastElements = lastMatrix.getElements();
                Object currentElements = currentMatrix.getElements();
                if (lastElements == null || currentElements == null) {
                    return DataChangeMonitoringFilter.valueChanged(lastValue, currentValue);
                }
                if (deadbandType == DeadbandType.Absolute) {
                    return DataChangeMonitoringFilter.compareArrayAbsoluteDeadband(lastElements, currentElements, filter.getDeadbandValue());
                }
                if (deadbandType == DeadbandType.Percent && euRange != null) {
                    return DataChangeMonitoringFilter.compareArrayPercentDeadband(lastElements, currentElements, filter.getDeadbandValue(), euRange);
                }
                return DataChangeMonitoringFilter.valueChanged(lastValue, currentValue);
            }
        }
        if (last.getClass().isArray() && current.getClass().isArray()) {
            if (deadbandType == DeadbandType.Absolute) {
                return DataChangeMonitoringFilter.compareArrayAbsoluteDeadband(last, current, filter.getDeadbandValue());
            }
            if (deadbandType == DeadbandType.Percent && euRange != null) {
                return DataChangeMonitoringFilter.compareArrayPercentDeadband(last, current, filter.getDeadbandValue(), euRange);
            }
            return DataChangeMonitoringFilter.valueChanged(lastValue, currentValue);
        }
        if (deadbandType == DeadbandType.Absolute) {
            return DataChangeMonitoringFilter.compareScalarAbsoluteDeadband(last, current, filter.getDeadbandValue());
        }
        if (deadbandType == DeadbandType.Percent && euRange != null) {
            return DataChangeMonitoringFilter.compareScalarPercentDeadband(last, current, filter.getDeadbandValue(), euRange);
        }
        return DataChangeMonitoringFilter.valueChanged(lastValue, currentValue);
    }

    private static boolean compareArrayAbsoluteDeadband(Object last, Object current, double deadband) {
        int currentLength;
        int lastLength = Array.getLength(last);
        if (lastLength != (currentLength = Array.getLength(current))) {
            return true;
        }
        for (int i = 0; i < lastLength; ++i) {
            Object currentElement;
            Object lastElement = Array.get(last, i);
            if (!DataChangeMonitoringFilter.exceedsAbsoluteDeadband(lastElement, currentElement = Array.get(current, i), deadband)) continue;
            return true;
        }
        return false;
    }

    private static boolean compareArrayPercentDeadband(Object last, Object current, double deadbandPercent, Range euRange) {
        int currentLength;
        int lastLength = Array.getLength(last);
        if (lastLength != (currentLength = Array.getLength(current))) {
            return true;
        }
        for (int i = 0; i < lastLength; ++i) {
            Object currentElement;
            Object lastElement = Array.get(last, i);
            if (!DataChangeMonitoringFilter.exceedsPercentDeadband(lastElement, currentElement = Array.get(current, i), deadbandPercent, euRange)) continue;
            return true;
        }
        return false;
    }

    private static boolean compareScalarAbsoluteDeadband(Object last, Object current, double deadband) {
        return DataChangeMonitoringFilter.exceedsAbsoluteDeadband(last, current, deadband);
    }

    private static boolean compareScalarPercentDeadband(Object last, Object current, double deadbandPercent, Range euRange) {
        return DataChangeMonitoringFilter.exceedsPercentDeadband(last, current, deadbandPercent, euRange);
    }

    private static boolean exceedsAbsoluteDeadband(Object last, Object current, double deadband) {
        try {
            double lastD = ((Number)last).doubleValue();
            double currentD = ((Number)current).doubleValue();
            if (Double.isNaN(lastD) && !Double.isNaN(currentD)) {
                return true;
            }
            return Math.abs(lastD - currentD) > deadband;
        }
        catch (Exception e) {
            return true;
        }
    }

    private static boolean exceedsPercentDeadband(Object last, Object current, double deadbandPercent, Range euRange) {
        double lastD = ((Number)last).doubleValue();
        double currentD = ((Number)current).doubleValue();
        double range = euRange.getHigh() - euRange.getLow();
        if (range <= 0.0 || Double.isNaN(lastD) && !Double.isNaN(currentD)) {
            return true;
        }
        try {
            double absoluteDeadband = deadbandPercent / 100.0 * range;
            return Math.abs(lastD - currentD) > absoluteDeadband;
        }
        catch (ClassCastException | NullPointerException | NumberFormatException e) {
            return true;
        }
    }

    private static boolean statusChanged(DataValue lastValue, DataValue currentValue) {
        return !Objects.equals(lastValue.statusCode(), currentValue.statusCode());
    }

    private static boolean valueChanged(DataValue lastValue, DataValue currentValue) {
        return !Objects.equals(lastValue.value(), currentValue.value());
    }

    private static boolean timestampChanged(DataValue lastValue, DataValue currentValue) {
        return !Objects.equals(lastValue.sourceTime(), currentValue.sourceTime());
    }

    private static @Nullable ValueType getValueType(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Matrix) {
            return ValueType.MATRIX;
        }
        if (value.getClass().isArray()) {
            return ValueType.ARRAY;
        }
        return ValueType.SCALAR;
    }

    private static enum ValueType {
        SCALAR,
        ARRAY,
        MATRIX;

    }
}

