/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.typetree;

import java.util.List;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.typetree.ObjectType;
import org.eclipse.milo.opcua.sdk.core.typetree.ObjectTypeTree;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectTypeNode;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.ReferenceTypes;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.util.Tree;

public class ObjectTypeTreeBuilder {
    public static ObjectTypeTree build(OpcUaServer server) {
        UaNode rootNode = server.getAddressSpaceManager().getManagedNode(NodeIds.BaseObjectType).orElseThrow();
        Tree tree = new Tree(null, (Object)new ServerObjectType((UaObjectTypeNode)rootNode));
        ObjectTypeTreeBuilder.addChildren((Tree<ObjectType>)tree, server);
        return new ObjectTypeTree(tree);
    }

    private static void addChildren(Tree<ObjectType> tree, OpcUaServer server) {
        NodeId nodeId = ((ObjectType)tree.getValue()).getNodeId();
        List<Reference> references = server.getAddressSpaceManager().getManagedReferences(nodeId, r -> r.isForward() && r.getReferenceTypeId().equals((Object)ReferenceTypes.HasSubtype));
        List childNodes = references.stream().flatMap(r -> server.getAddressSpaceManager().getManagedNode(r.getTargetNodeId()).stream()).toList();
        for (UaNode childNode : childNodes) {
            UaObjectTypeNode objectTypeNode = (UaObjectTypeNode)childNode;
            tree.addChild((Object)new ServerObjectType(objectTypeNode));
        }
        for (Tree child : tree.getChildren()) {
            ObjectTypeTreeBuilder.addChildren((Tree<ObjectType>)child, server);
        }
    }

    private static class ServerObjectType
    implements ObjectType {
        private final UaObjectTypeNode node;

        public ServerObjectType(UaObjectTypeNode node) {
            this.node = node;
        }

        public QualifiedName getBrowseName() {
            return this.node.getBrowseName();
        }

        public NodeId getNodeId() {
            return this.node.getNodeId();
        }

        public Boolean isAbstract() {
            return this.node.getIsAbstract();
        }
    }
}

