/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.typetree;

import java.util.List;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.typetree.DataType;
import org.eclipse.milo.opcua.sdk.core.typetree.DataTypeTree;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.nodes.UaDataTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.ReferenceTypes;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.jspecify.annotations.Nullable;

public class DataTypeTreeBuilder {
    public static DataTypeTree build(OpcUaServer server) {
        UaNode rootNode = server.getAddressSpaceManager().getManagedNode(NodeIds.BaseDataType).orElseThrow();
        Tree tree = new Tree(null, (Object)new ServerDataType((UaDataTypeNode)rootNode, null, null, null));
        DataTypeTreeBuilder.addChildren((Tree<DataType>)tree, server);
        return new DataTypeTree(tree);
    }

    private static void addChildren(Tree<DataType> tree, OpcUaServer server) {
        NodeId nodeId = ((DataType)tree.getValue()).getNodeId();
        List<Reference> references = server.getAddressSpaceManager().getManagedReferences(nodeId, r -> r.isForward() && r.getReferenceTypeId().equals((Object)ReferenceTypes.HasSubtype));
        List childNodes = references.stream().flatMap(r -> server.getAddressSpaceManager().getManagedNode(r.getTargetNodeId()).stream()).toList();
        for (UaNode childNode : childNodes) {
            UaDataTypeNode dataTypeNode = (UaDataTypeNode)childNode;
            NodeId binaryEncodingId = null;
            NodeId xmlEncodingId = null;
            NodeId jsonEncodingId = null;
            for (Reference reference : dataTypeNode.getReferences()) {
                if (!reference.getReferenceTypeId().equals((Object)NodeIds.HasEncoding)) continue;
                QualifiedName browseName = server.getAddressSpaceManager().getManagedNode(reference.getTargetNodeId()).map(UaNode::getBrowseName).orElse(null);
                if (DataTypeEncoding.BINARY_ENCODING_NAME.equals((Object)browseName)) {
                    binaryEncodingId = reference.getTargetNodeId().toNodeId(server.getNamespaceTable()).orElse(null);
                    continue;
                }
                if (DataTypeEncoding.XML_ENCODING_NAME.equals((Object)browseName)) {
                    xmlEncodingId = reference.getTargetNodeId().toNodeId(server.getNamespaceTable()).orElse(null);
                    continue;
                }
                if (!DataTypeEncoding.JSON_ENCODING_NAME.equals((Object)browseName)) continue;
                jsonEncodingId = reference.getTargetNodeId().toNodeId(server.getNamespaceTable()).orElse(null);
            }
            tree.addChild((Object)new ServerDataType(dataTypeNode, binaryEncodingId, xmlEncodingId, jsonEncodingId));
        }
        for (Tree child : tree.getChildren()) {
            DataTypeTreeBuilder.addChildren((Tree<DataType>)child, server);
        }
    }

    private static class ServerDataType
    implements DataType {
        private final UaDataTypeNode node;
        private final @Nullable NodeId binaryEncodingId;
        private final @Nullable NodeId xmlEncodingId;
        private final @Nullable NodeId jsonEncodingId;

        public ServerDataType(UaDataTypeNode node, @Nullable NodeId binaryEncodingId, @Nullable NodeId xmlEncodingId, @Nullable NodeId jsonEncodingId) {
            this.node = node;
            this.binaryEncodingId = binaryEncodingId;
            this.xmlEncodingId = xmlEncodingId;
            this.jsonEncodingId = jsonEncodingId;
        }

        public QualifiedName getBrowseName() {
            return this.node.getBrowseName();
        }

        public NodeId getNodeId() {
            return this.node.getNodeId();
        }

        public @Nullable NodeId getBinaryEncodingId() {
            return this.binaryEncodingId;
        }

        public @Nullable NodeId getXmlEncodingId() {
            return this.xmlEncodingId;
        }

        public @Nullable NodeId getJsonEncodingId() {
            return this.jsonEncodingId;
        }

        public DataTypeDefinition getDataTypeDefinition() {
            return this.node.getDataTypeDefinition();
        }

        public Boolean isAbstract() {
            return this.node.getIsAbstract();
        }
    }
}

