/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.subscriptions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.core.NumericRange;
import org.eclipse.milo.opcua.sdk.core.util.GroupMapCollate;
import org.eclipse.milo.opcua.sdk.server.AddressSpace;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.items.BaseMonitoredItem;
import org.eclipse.milo.opcua.sdk.server.items.DataItem;
import org.eclipse.milo.opcua.sdk.server.items.EventItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredDataItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredEventItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.servicesets.AbstractServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.AccessController;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.helpers.BrowseHelper;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.helpers.BrowsePathsHelper;
import org.eclipse.milo.opcua.sdk.server.subscriptions.PublishQueue;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionCreatedEvent;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionDeletedEvent;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DeadbandType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathResult;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathTarget;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DataChangeFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationMessage;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePathElement;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionAcknowledgement;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.eclipse.milo.opcua.stack.transport.server.ServiceRequestContext;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class SubscriptionManager {
    private static final AtomicLong SUBSCRIPTION_IDS = new AtomicLong(0L);
    private static final QualifiedName EU_RANGE_BROWSE_NAME = new QualifiedName(0, "EURange");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<UInteger, Subscription> subscriptions = new ConcurrentHashMap<UInteger, Subscription>();
    private final List<Subscription> transferred = new CopyOnWriteArrayList<Subscription>();
    private final AtomicLong monitoredItemCount = new AtomicLong(0L);
    private final PublishQueue publishQueue;
    private final Session session;
    private final OpcUaServer server;

    public SubscriptionManager(Session session, OpcUaServer server) {
        this.session = session;
        this.server = server;
        this.publishQueue = new PublishQueue(server.getConfig().getExecutor());
    }

    public Session getSession() {
        return this.session;
    }

    public PublishQueue getPublishQueue() {
        return this.publishQueue;
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    public @Nullable Subscription getSubscription(UInteger subscriptionId) {
        return this.subscriptions.get(subscriptionId);
    }

    public List<Subscription> getSubscriptions() {
        return new ArrayList<Subscription>(this.subscriptions.values());
    }

    public CompletableFuture<CreateSubscriptionResponse> createSubscription(CreateSubscriptionRequest request) {
        if (this.subscriptions.size() >= this.server.getConfig().getLimits().getMaxSubscriptionsPerSession().intValue()) {
            return FutureUtils.failedUaFuture((long)0x80770000L);
        }
        if (this.server.getSubscriptions().size() >= this.server.getConfig().getLimits().getMaxSubscriptions().intValue()) {
            return FutureUtils.failedUaFuture((long)0x80770000L);
        }
        UInteger subscriptionId = SubscriptionManager.nextSubscriptionId();
        Subscription subscription = new Subscription(this, subscriptionId, request.getRequestedPublishingInterval(), request.getRequestedMaxKeepAliveCount().longValue(), request.getRequestedLifetimeCount().longValue(), request.getMaxNotificationsPerPublish().longValue(), request.getPublishingEnabled(), request.getPriority().intValue());
        this.subscriptions.put(subscriptionId, subscription);
        this.server.getSubscriptions().put(subscriptionId, subscription);
        this.server.getDiagnosticsSummary().getCumulatedSubscriptionCount().increment();
        this.server.getInternalEventBus().post((Object)new SubscriptionCreatedEvent(subscription));
        subscription.setStateListener((s, ps, cs) -> {
            if (cs == Subscription.State.Closing) {
                this.subscriptions.remove(s.getId());
                this.server.getSubscriptions().remove(s.getId());
                this.server.getInternalEventBus().post((Object)new SubscriptionDeletedEvent(s));
                Map<UInteger, BaseMonitoredItem<?>> monitoredItems = s.getMonitoredItems();
                SubscriptionManager.byMonitoredItemType(monitoredItems.values(), dataItems -> this.server.getAddressSpaceManager().onDataItemsDeleted((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsDeleted((List<EventItem>)eventItems));
                this.monitoredItemCount.getAndUpdate(count -> count - (long)monitoredItems.size());
                this.server.getMonitoredItemCount().getAndUpdate(count -> count - (long)monitoredItems.size());
                monitoredItems.clear();
            }
        });
        subscription.startPublishingTimer();
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        CreateSubscriptionResponse response = new CreateSubscriptionResponse(header, subscriptionId, Double.valueOf(subscription.getPublishingInterval()), Unsigned.uint((long)subscription.getLifetimeCount()), Unsigned.uint((long)subscription.getMaxKeepAliveCount()));
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<ModifySubscriptionResponse> modifySubscription(ModifySubscriptionRequest request) {
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        if (subscription == null) {
            return FutureUtils.failedUaFuture((long)0x80280000L);
        }
        subscription.modifySubscription(request);
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        ModifySubscriptionResponse response = new ModifySubscriptionResponse(header, Double.valueOf(subscription.getPublishingInterval()), Unsigned.uint((long)subscription.getLifetimeCount()), Unsigned.uint((long)subscription.getMaxKeepAliveCount()));
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<DeleteSubscriptionsResponse> deleteSubscriptions(DeleteSubscriptionsRequest request) {
        UInteger[] subscriptionIds = Objects.requireNonNullElse(request.getSubscriptionIds(), new UInteger[0]);
        if (subscriptionIds.length == 0) {
            return FutureUtils.failedUaFuture((long)0x800F0000L);
        }
        StatusCode[] results = new StatusCode[subscriptionIds.length];
        for (int i = 0; i < subscriptionIds.length; ++i) {
            UInteger subscriptionId = subscriptionIds[i];
            Subscription subscription = this.subscriptions.remove(subscriptionId);
            if (subscription != null) {
                this.server.getSubscriptions().remove(subscription.getId());
                this.server.getInternalEventBus().post((Object)new SubscriptionDeletedEvent(subscription));
                List<BaseMonitoredItem<?>> deletedItems = subscription.deleteSubscription();
                SubscriptionManager.byMonitoredItemType(deletedItems, dataItems -> this.server.getAddressSpaceManager().onDataItemsDeleted((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsDeleted((List<EventItem>)eventItems));
                results[i] = StatusCode.GOOD;
                this.monitoredItemCount.getAndUpdate(count -> count - (long)deletedItems.size());
                this.server.getMonitoredItemCount().getAndUpdate(count -> count - (long)deletedItems.size());
                continue;
            }
            results[i] = new StatusCode(0x80280000L);
        }
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        DeleteSubscriptionsResponse response = new DeleteSubscriptionsResponse(header, results, new DiagnosticInfo[0]);
        while (this.subscriptions.isEmpty() && this.publishQueue.isNotEmpty()) {
            PublishQueue.PendingPublish pending = this.publishQueue.poll();
            if (pending == null) continue;
            pending.responseFuture.completeExceptionally(new UaException(2155413504L));
        }
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<SetPublishingModeResponse> setPublishingMode(SetPublishingModeRequest request) {
        UInteger[] subscriptionIds = request.getSubscriptionIds();
        if (subscriptionIds == null || subscriptionIds.length == 0) {
            return FutureUtils.failedUaFuture((long)0x800F0000L);
        }
        StatusCode[] results = new StatusCode[subscriptionIds.length];
        for (int i = 0; i < subscriptionIds.length; ++i) {
            Subscription subscription = this.subscriptions.get(subscriptionIds[i]);
            if (subscription == null) {
                results[i] = new StatusCode(0x80280000L);
                continue;
            }
            subscription.setPublishingMode(request);
            results[i] = StatusCode.GOOD;
        }
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        SetPublishingModeResponse response = new SetPublishingModeResponse(header, results, new DiagnosticInfo[0]);
        return CompletableFuture.completedFuture(response);
    }

    public CreateMonitoredItemsResponse createMonitoredItems(ServiceRequestContext context, CreateMonitoredItemsRequest request) throws UaException {
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        TimestampsToReturn timestamps = request.getTimestampsToReturn();
        List itemsToCreate = Lists.ofNullable((Object[])request.getItemsToCreate());
        if (subscription == null) {
            throw new UaException(0x80280000L);
        }
        if (timestamps == null) {
            throw new UaException(2150301696L);
        }
        if (itemsToCreate.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        Map<ReadValueId, AccessController.AccessResult> accessResults = this.server.getAccessController().checkReadAccess(this.session, itemsToCreate.stream().map(MonitoredItemCreateRequest::getItemToMonitor).toList());
        List results = GroupMapCollate.groupMapCollate((List)itemsToCreate, createRequest -> (AccessController.AccessResult)accessResults.get(createRequest.getItemToMonitor()), accessResult -> group -> {
            if (accessResult instanceof AccessController.AccessResult.Denied) {
                AccessController.AccessResult.Denied denied = (AccessController.AccessResult.Denied)accessResult;
                MonitoredItemCreateResult result = new MonitoredItemCreateResult(denied.statusCode(), Unsigned.uint((int)0), Double.valueOf(0.0), Unsigned.uint((int)0), null);
                return Collections.nCopies(group.size(), result);
            }
            return this.createMonitoredItems(subscription, timestamps, (List<MonitoredItemCreateRequest>)group);
        });
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new CreateMonitoredItemsResponse(header, results.toArray(new MonitoredItemCreateResult[0]), new DiagnosticInfo[0]);
    }

    private List<MonitoredItemCreateResult> createMonitoredItems(Subscription subscription, TimestampsToReturn timestamps, List<MonitoredItemCreateRequest> requests) {
        ArrayList<MonitoredItemCreateRequest> regularRequests = new ArrayList<MonitoredItemCreateRequest>();
        ArrayList<MonitoredItemCreateRequest> percentDeadbandRequests = new ArrayList<MonitoredItemCreateRequest>();
        for (MonitoredItemCreateRequest request : requests) {
            boolean isValueAttribute = request.getItemToMonitor().getAttributeId().equals((Object)AttributeId.Value.uid());
            if (isValueAttribute && this.hasPercentDeadbandFilter(request)) {
                percentDeadbandRequests.add(request);
                continue;
            }
            regularRequests.add(request);
        }
        Map<Object, Object> regularAttributes = regularRequests.isEmpty() ? Collections.emptyMap() : this.readMonitoringAttributes(regularRequests.stream().map(r -> r.getItemToMonitor().getNodeId()).toList());
        Map<Object, Object> analogItemAttributes = percentDeadbandRequests.isEmpty() ? Collections.emptyMap() : this.readAnalogItemAttributes(percentDeadbandRequests.stream().map(r -> r.getItemToMonitor().getNodeId()).toList());
        ArrayList<MonitoredItemCreateResult> results = new ArrayList<MonitoredItemCreateResult>();
        ArrayList monitoredItems = new ArrayList();
        long globalMax = this.server.getConfig().getLimits().getMaxMonitoredItems().longValue();
        long sessionMax = this.server.getConfig().getLimits().getMaxMonitoredItemsPerSession().longValue();
        for (MonitoredItemCreateRequest request : requests) {
            try {
                long globalCount = this.server.getMonitoredItemCount().incrementAndGet();
                long sessionCount = this.monitoredItemCount.incrementAndGet();
                if (globalCount <= globalMax && sessionCount <= sessionMax) {
                    boolean isValueAttribute = request.getItemToMonitor().getAttributeId().equals((Object)AttributeId.Value.uid());
                    AttributesResponse attributesResponse = isValueAttribute && this.hasPercentDeadbandFilter(request) ? (AttributesResponse)analogItemAttributes.get(request.getItemToMonitor().getNodeId()) : (AttributesResponse)regularAttributes.get(request.getItemToMonitor().getNodeId());
                    BaseMonitoredItem<?> monitoredItem = this.createMonitoredItem(request, subscription, timestamps, attributesResponse);
                    monitoredItems.add(monitoredItem);
                    results.add(new MonitoredItemCreateResult(StatusCode.GOOD, monitoredItem.getId(), Double.valueOf(monitoredItem.getSamplingInterval()), Unsigned.uint((int)monitoredItem.getQueueSize()), monitoredItem.getFilterResult()));
                    continue;
                }
                throw new UaException(2161836032L);
            }
            catch (UaException e) {
                this.monitoredItemCount.decrementAndGet();
                this.server.getMonitoredItemCount().decrementAndGet();
                results.add(new MonitoredItemCreateResult(e.getStatusCode(), UInteger.MIN, Double.valueOf(0.0), UInteger.MIN, null));
            }
        }
        subscription.addMonitoredItems(monitoredItems);
        SubscriptionManager.byMonitoredItemType(monitoredItems, dataItems -> this.server.getAddressSpaceManager().onDataItemsCreated((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsCreated((List<EventItem>)eventItems));
        return results;
    }

    private boolean hasPercentDeadbandFilter(MonitoredItemCreateRequest request) {
        try {
            ExtensionObject filterXo = request.getRequestedParameters().getFilter();
            if (filterXo == null || filterXo.isNull()) {
                return false;
            }
            UaStructuredType filterObject = filterXo.decode(this.server.getStaticEncodingContext());
            if (filterObject instanceof DataChangeFilter) {
                DataChangeFilter filter = (DataChangeFilter)filterObject;
                DeadbandType deadbandType = DeadbandType.from((int)filter.getDeadbandType().intValue());
                return deadbandType == DeadbandType.Percent;
            }
            return false;
        }
        catch (UaSerializationException e) {
            this.logger.debug("Failed to decode filter when checking for Percent Deadband", (Throwable)e);
            return false;
        }
    }

    private MonitoredDataItem createMonitoredDataItem(MonitoredItemCreateRequest request, Subscription subscription, TimestampsToReturn timestamps, AttributeId attributeId, MonitoringAttributes attributes, @Nullable Range euRange) throws UaException {
        AddressSpace.RevisedDataItemParameters revisedParameters;
        Double minimumSamplingInterval;
        NodeClass nodeClass = attributes.nodeClass();
        if (nodeClass == null) {
            throw new UaException(2150891520L);
        }
        if (!AttributeId.getAttributes((NodeClass)nodeClass).contains(attributeId)) {
            throw new UaException(2150957056L);
        }
        String indexRange = request.getItemToMonitor().getIndexRange();
        if (indexRange != null && !indexRange.isEmpty()) {
            NumericRange.parse((String)indexRange);
        }
        if ((minimumSamplingInterval = attributes.minimumSamplingInterval()) == null) {
            minimumSamplingInterval = this.server.getConfig().getLimits().getMinSupportedSampleRate();
        }
        DataChangeFilter filter = MonitoredDataItem.DEFAULT_FILTER;
        try {
            ExtensionObject filterXo = request.getRequestedParameters().getFilter();
            if (filterXo != null && !filterXo.isNull()) {
                UaStructuredType filterObject = filterXo.decode(this.server.getStaticEncodingContext());
                filter = this.validateDataItemFilter(filterObject, attributeId, attributes);
            }
        }
        catch (UaSerializationException e) {
            this.logger.debug("error decoding MonitoringFilter", (Throwable)e);
            throw new UaException(2151874560L, (Throwable)e);
        }
        double requestedSamplingInterval = this.getSamplingInterval(subscription, minimumSamplingInterval, request.getRequestedParameters().getSamplingInterval());
        try {
            revisedParameters = this.server.getAddressSpaceManager().onCreateDataItem(request.getItemToMonitor(), requestedSamplingInterval, request.getRequestedParameters().getQueueSize());
        }
        catch (Throwable t) {
            throw new UaException(0x80020000L, t);
        }
        MonitoredDataItem monitoredItem = new MonitoredDataItem(this.server, this.session, Unsigned.uint((long)subscription.nextItemId()), subscription.getId(), request.getItemToMonitor(), request.getMonitoringMode(), timestamps, request.getRequestedParameters().getClientHandle(), revisedParameters.revisedSamplingInterval(), revisedParameters.revisedQueueSize(), request.getRequestedParameters().getDiscardOldest());
        if (euRange != null) {
            monitoredItem.setEuRange(euRange);
        }
        monitoredItem.installFilter((MonitoringFilter)filter);
        return monitoredItem;
    }

    private MonitoredEventItem createMonitoredEventItem(MonitoredItemCreateRequest request, Subscription subscription, TimestampsToReturn timestamps, MonitoringAttributes attributes) throws UaException {
        AddressSpace.RevisedEventItemParameters revisedParameters;
        UByte eventNotifier = attributes.eventNotifier();
        if (eventNotifier == null || (eventNotifier.intValue() & 1) == 0) {
            throw new UaException(2150957056L);
        }
        UaStructuredType filterObject = request.getRequestedParameters().getFilter().decode(this.server.getStaticEncodingContext());
        MonitoringFilter filter = this.validateEventItemFilter(filterObject);
        try {
            revisedParameters = this.server.getAddressSpaceManager().onCreateEventItem(request.getItemToMonitor(), request.getRequestedParameters().getQueueSize());
        }
        catch (Throwable t) {
            throw new UaException(0x80020000L, t);
        }
        MonitoredEventItem monitoredEventItem = new MonitoredEventItem(this.server, this.session, Unsigned.uint((long)subscription.nextItemId()), subscription.getId(), request.getItemToMonitor(), request.getMonitoringMode(), timestamps, request.getRequestedParameters().getClientHandle(), 0.0, revisedParameters.revisedQueueSize(), request.getRequestedParameters().getDiscardOldest());
        monitoredEventItem.installFilter(filter);
        return monitoredEventItem;
    }

    private BaseMonitoredItem<?> createMonitoredItem(MonitoredItemCreateRequest request, Subscription subscription, TimestampsToReturn timestamps, AttributesResponse attributeResponse) throws UaException {
        QualifiedName dataEncoding = request.getItemToMonitor().getDataEncoding();
        AttributeId attributeId = (AttributeId)AttributeId.from((UInteger)request.getItemToMonitor().getAttributeId()).orElseThrow(() -> new UaException(2150957056L));
        if (dataEncoding.isNotNull()) {
            if (attributeId != AttributeId.Value) {
                throw new UaException(0x80380000L);
            }
            if (!this.server.getEncodingManager().hasEncoding(dataEncoding)) {
                throw new UaException(2151219200L);
            }
        }
        if (attributeResponse instanceof NegativeResponse) {
            NegativeResponse negativeResponse = (NegativeResponse)attributeResponse;
            throw new UaException(negativeResponse.statusCode());
        }
        if (attributeResponse instanceof AnalogItemAttributes) {
            AnalogItemAttributes analogItemAttributes = (AnalogItemAttributes)attributeResponse;
            if (attributeId != AttributeId.Value) {
                throw new IllegalStateException("AnalogItemAttributes received for non-Value attribute: " + String.valueOf(attributeId));
            }
            MonitoringAttributes monitoringAttributes = analogItemAttributes.monitoringAttributes();
            Range euRange = analogItemAttributes.euRange();
            if (euRange == null) {
                throw new UaException(0x80440000L, "Percent Deadband requires AnalogItemType with valid EURange property");
            }
            return this.createMonitoredDataItem(request, subscription, timestamps, attributeId, monitoringAttributes, euRange);
        }
        if (attributeResponse instanceof MonitoringAttributes) {
            MonitoringAttributes monitoringAttributes = (MonitoringAttributes)attributeResponse;
            if (attributeId == AttributeId.EventNotifier) {
                return this.createMonitoredEventItem(request, subscription, timestamps, monitoringAttributes);
            }
            return this.createMonitoredDataItem(request, subscription, timestamps, attributeId, monitoringAttributes, null);
        }
        throw new UaException(0x80020000L, "Unexpected AttributesResponse type");
    }

    private MonitoringFilter validateDataItemFilter(Object filterObject, AttributeId attributeId, MonitoringAttributes monitoringAttributes) throws UaException {
        if (filterObject instanceof MonitoringFilter) {
            if (filterObject instanceof DataChangeFilter) {
                DataChangeFilter filter = (DataChangeFilter)filterObject;
                DeadbandType deadbandType = DeadbandType.from((int)filter.getDeadbandType().intValue());
                if (deadbandType == null) {
                    throw new UaException(0x808E0000L);
                }
                if ((deadbandType == DeadbandType.Absolute || deadbandType == DeadbandType.Percent) && attributeId != AttributeId.Value) {
                    throw new UaException(2152005632L);
                }
                if (deadbandType != DeadbandType.None) {
                    NodeId dataTypeId = monitoringAttributes.dataType();
                    if (dataTypeId == null) {
                        dataTypeId = NodeId.NULL_VALUE;
                    }
                    if (!NodeIds.Number.equals((Object)dataTypeId) && !this.server.getDataTypeTree().isSubtypeOf(dataTypeId, NodeIds.Number)) {
                        throw new UaException(2152005632L);
                    }
                }
                return filter;
            }
            if (filterObject instanceof EventFilter) {
                throw new UaException(2152005632L);
            }
            throw new UaException(0x80440000L);
        }
        throw new UaException(2151874560L);
    }

    private MonitoringFilter validateEventItemFilter(Object filterObject) throws UaException {
        if (filterObject instanceof MonitoringFilter) {
            if (!(filterObject instanceof EventFilter)) {
                throw new UaException(2152005632L);
            }
            return (EventFilter)filterObject;
        }
        throw new UaException(2151874560L);
    }

    public ModifyMonitoredItemsResponse modifyMonitoredItems(ServiceRequestContext context, ModifyMonitoredItemsRequest request) throws UaException {
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        TimestampsToReturn timestamps = request.getTimestampsToReturn();
        MonitoredItemModifyRequest[] itemsToModify = request.getItemsToModify();
        if (subscription == null) {
            throw new UaException(0x80280000L);
        }
        if (timestamps == null) {
            throw new UaException(2150301696L);
        }
        if (itemsToModify == null || itemsToModify.length == 0) {
            throw new UaException(0x800F0000L);
        }
        List<NodeId> nodeIds = Stream.of(itemsToModify).map(item -> {
            UInteger itemId = item.getMonitoredItemId();
            BaseMonitoredItem<?> monitoredItem = subscription.getMonitoredItems().get(itemId);
            return monitoredItem != null ? monitoredItem.getReadValueId().getNodeId() : NodeId.NULL_VALUE;
        }).filter(NodeId::isNotNull).collect(Collectors.toList());
        Map<NodeId, AttributesResponse> attributesMap = this.readMonitoringAttributes(nodeIds);
        MonitoredItemModifyResult[] modifyResults = new MonitoredItemModifyResult[itemsToModify.length];
        ArrayList monitoredItems = new ArrayList();
        for (int i = 0; i < itemsToModify.length; ++i) {
            MonitoredItemModifyRequest modifyRequest = itemsToModify[i];
            try {
                BaseMonitoredItem<?> monitoredItem = this.modifyMonitoredItem(modifyRequest, timestamps, subscription, attributesMap);
                monitoredItems.add(monitoredItem);
                modifyResults[i] = new MonitoredItemModifyResult(StatusCode.GOOD, Double.valueOf(monitoredItem.getSamplingInterval()), Unsigned.uint((int)monitoredItem.getQueueSize()), monitoredItem.getFilterResult());
                continue;
            }
            catch (UaException e) {
                modifyResults[i] = new MonitoredItemModifyResult(e.getStatusCode(), Double.valueOf(0.0), UInteger.MIN, null);
            }
        }
        subscription.resetLifetimeCounter();
        SubscriptionManager.byMonitoredItemType(monitoredItems, dataItems -> this.server.getAddressSpaceManager().onDataItemsModified((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsModified((List<EventItem>)eventItems));
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new ModifyMonitoredItemsResponse(header, modifyResults, new DiagnosticInfo[0]);
    }

    private BaseMonitoredItem<?> modifyMonitoredItem(MonitoredItemModifyRequest request, TimestampsToReturn timestamps, Subscription subscription, Map<NodeId, AttributesResponse> attributeResponses) throws UaException {
        UInteger itemId = request.getMonitoredItemId();
        MonitoringParameters parameters = request.getRequestedParameters();
        BaseMonitoredItem<?> monitoredItem = subscription.getMonitoredItems().get(itemId);
        if (monitoredItem == null) {
            throw new UaException(2151809024L);
        }
        NodeId nodeId = monitoredItem.getReadValueId().getNodeId();
        AttributeId attributeId = (AttributeId)AttributeId.from((UInteger)monitoredItem.getReadValueId().getAttributeId()).orElseThrow(() -> new UaException(2150957056L));
        AttributesResponse response = attributeResponses.get(nodeId);
        if (response instanceof NegativeResponse) {
            NegativeResponse negativeResponse = (NegativeResponse)response;
            throw new UaException(negativeResponse.statusCode());
        }
        MonitoringAttributes monitoringAttributes = (MonitoringAttributes)response;
        if (attributeId == AttributeId.EventNotifier) {
            AddressSpace.RevisedEventItemParameters revisedParameters;
            UaStructuredType filterObject = request.getRequestedParameters().getFilter().decode(this.server.getStaticEncodingContext());
            MonitoringFilter filter = this.validateEventItemFilter(filterObject);
            try {
                revisedParameters = this.server.getAddressSpaceManager().onModifyEventItem(monitoredItem.getReadValueId(), parameters.getQueueSize());
            }
            catch (Throwable t) {
                throw new UaException(0x80020000L, t);
            }
            monitoredItem.modify(timestamps, parameters.getClientHandle(), monitoredItem.getSamplingInterval(), filter, revisedParameters.revisedQueueSize(), parameters.getDiscardOldest());
        } else {
            AddressSpace.RevisedDataItemParameters revisedParameters;
            DataChangeFilter filter;
            block14: {
                filter = MonitoredDataItem.DEFAULT_FILTER;
                try {
                    DeadbandType deadbandType;
                    ExtensionObject filterXo = request.getRequestedParameters().getFilter();
                    if (filterXo == null || filterXo.isNull()) break block14;
                    UaStructuredType filterObject = filterXo.decode(this.server.getStaticEncodingContext());
                    filter = this.validateDataItemFilter(filterObject, attributeId, monitoringAttributes);
                    if (!(filterObject instanceof DataChangeFilter)) break block14;
                    DataChangeFilter dataChangeFilter = (DataChangeFilter)filterObject;
                    if (!(monitoredItem instanceof MonitoredDataItem)) break block14;
                    MonitoredDataItem dataItem = (MonitoredDataItem)monitoredItem;
                    if (attributeId != AttributeId.Value || (deadbandType = DeadbandType.from((int)dataChangeFilter.getDeadbandType().intValue())) != DeadbandType.Percent || dataItem.getEuRange() != null) break block14;
                    Map<NodeId, AttributesResponse> analogAttrs = this.readAnalogItemAttributes(List.of(nodeId));
                    AttributesResponse analogResponse = analogAttrs.get(nodeId);
                    if (analogResponse instanceof AnalogItemAttributes) {
                        AnalogItemAttributes analogItemAttributes = (AnalogItemAttributes)analogResponse;
                        Range euRange = analogItemAttributes.euRange();
                        if (euRange == null) {
                            throw new UaException(0x80440000L, "Percent Deadband requires AnalogItemType with valid EURange property");
                        }
                        dataItem.setEuRange(euRange);
                        break block14;
                    }
                    if (analogResponse instanceof NegativeResponse) {
                        NegativeResponse negResp = (NegativeResponse)analogResponse;
                        throw new UaException(negResp.statusCode());
                    }
                    throw new UaException(0x80440000L, "Percent Deadband requires AnalogItemType with valid EURange property");
                }
                catch (UaSerializationException e) {
                    this.logger.debug("error decoding MonitoringFilter", (Throwable)e);
                    throw new UaException(2151874560L, (Throwable)e);
                }
            }
            Double minimumSamplingInterval = monitoringAttributes.minimumSamplingInterval();
            if (minimumSamplingInterval == null) {
                minimumSamplingInterval = this.server.getConfig().getLimits().getMinSupportedSampleRate();
            }
            double requestedSamplingInterval = this.getSamplingInterval(subscription, minimumSamplingInterval, request.getRequestedParameters().getSamplingInterval());
            UInteger requestedQueueSize = parameters.getQueueSize();
            try {
                revisedParameters = this.server.getAddressSpaceManager().onModifyDataItem(monitoredItem.getReadValueId(), requestedSamplingInterval, requestedQueueSize);
            }
            catch (Throwable t) {
                throw new UaException(0x80020000L, t);
            }
            monitoredItem.modify(timestamps, parameters.getClientHandle(), revisedParameters.revisedSamplingInterval(), (MonitoringFilter)filter, revisedParameters.revisedQueueSize(), parameters.getDiscardOldest());
        }
        return monitoredItem;
    }

    private double getSamplingInterval(Subscription subscription, Double minimumSamplingInterval, Double requestedSamplingInterval) {
        double samplingInterval = requestedSamplingInterval;
        if (requestedSamplingInterval < 0.0) {
            samplingInterval = subscription.getPublishingInterval();
        } else if (requestedSamplingInterval == 0.0) {
            if (minimumSamplingInterval < 0.0) {
                samplingInterval = subscription.getPublishingInterval();
            } else if (minimumSamplingInterval == 0.0) {
                samplingInterval = minimumSamplingInterval;
            } else if (minimumSamplingInterval > 0.0) {
                samplingInterval = minimumSamplingInterval;
            }
        } else if (requestedSamplingInterval < minimumSamplingInterval) {
            samplingInterval = minimumSamplingInterval;
        }
        double minSupportedSampleRate = this.server.getConfig().getLimits().getMinSupportedSampleRate();
        double maxSupportedSampleRate = this.server.getConfig().getLimits().getMaxSupportedSampleRate();
        if (samplingInterval < minSupportedSampleRate) {
            samplingInterval = minSupportedSampleRate;
        }
        if (samplingInterval > maxSupportedSampleRate) {
            samplingInterval = maxSupportedSampleRate;
        }
        return samplingInterval;
    }

    private Map<NodeId, AttributesResponse> readMonitoringAttributes(List<NodeId> nodeIds) {
        List<ReadValueId> readValueIds = nodeIds.stream().distinct().flatMap(nodeId -> {
            Function<AttributeId, ReadValueId> f = id -> new ReadValueId(nodeId, id.uid(), null, QualifiedName.NULL_VALUE);
            return Stream.of(f.apply(AttributeId.NodeClass), f.apply(AttributeId.EventNotifier), f.apply(AttributeId.DataType), f.apply(AttributeId.MinimumSamplingInterval));
        }).collect(Collectors.toList());
        AddressSpace.ReadContext context = new AddressSpace.ReadContext(this.server, this.session);
        List<DataValue> values = this.server.getAddressSpaceManager().read(context, 0.0, TimestampsToReturn.Neither, readValueIds);
        HashMap<NodeId, AttributesResponse> attributesMap = new HashMap<NodeId, AttributesResponse>();
        for (int i = 0; i < values.size(); i += 4) {
            NodeId nodeId2 = readValueIds.get(i).getNodeId();
            DataValue dv0 = values.get(i);
            if (dv0.statusCode().isBad()) {
                attributesMap.put(nodeId2, new NegativeResponse(dv0.statusCode()));
                continue;
            }
            Object v0 = dv0.value().value();
            Object v1 = values.get(i + 1).value().value();
            Object v2 = values.get(i + 2).value().value();
            Object v3 = values.get(i + 3).value().value();
            NodeClass nodeClass = (NodeClass)v0;
            NodeId dataType = null;
            UByte eventNotifier = null;
            Double minimumSamplingInterval = null;
            if (v1 instanceof UByte) {
                UByte b;
                eventNotifier = b = (UByte)v1;
            }
            if (v2 instanceof NodeId) {
                NodeId id;
                dataType = id = (NodeId)v2;
            }
            if (v3 instanceof Double) {
                Double d;
                minimumSamplingInterval = d = (Double)v3;
            }
            MonitoringAttributes attributes = new MonitoringAttributes(nodeClass, eventNotifier, dataType, minimumSamplingInterval);
            attributesMap.put(nodeId2, attributes);
        }
        return attributesMap;
    }

    private Map<NodeId, AttributesResponse> readAnalogItemAttributes(List<NodeId> nodeIds) {
        Map<NodeId, AttributesResponse> basicAttributes = this.readMonitoringAttributes(nodeIds);
        List<NodeId> distinctNodeIds = nodeIds.stream().distinct().toList();
        Map<NodeId, NodeId> typeDefinitions = this.readTypeDefinitions(distinctNodeIds);
        ArrayList<NodeId> analogItemNodeIds = new ArrayList<NodeId>();
        for (Map.Entry<NodeId, NodeId> entry : typeDefinitions.entrySet()) {
            if (!this.isAnalogItemType(entry.getValue())) continue;
            analogItemNodeIds.add(entry.getKey());
        }
        Map<NodeId, Range> euRanges = this.readEURanges(analogItemNodeIds);
        HashMap<NodeId, AttributesResponse> result = new HashMap<NodeId, AttributesResponse>();
        for (NodeId nodeId : nodeIds) {
            AttributesResponse attrs = basicAttributes.get(nodeId);
            Range euRange = euRanges.get(nodeId);
            if (attrs instanceof MonitoringAttributes) {
                MonitoringAttributes monitoringAttrs = (MonitoringAttributes)attrs;
                result.put(nodeId, new AnalogItemAttributes(monitoringAttrs, euRange));
                continue;
            }
            if (!(attrs instanceof NegativeResponse)) continue;
            NegativeResponse negResp = (NegativeResponse)attrs;
            result.put(nodeId, negResp);
        }
        return result;
    }

    private Map<NodeId, NodeId> readTypeDefinitions(List<NodeId> nodeIds) {
        BrowseDescription[] browseDescriptions = (BrowseDescription[])nodeIds.stream().map(nodeId -> new BrowseDescription(nodeId, BrowseDirection.Forward, NodeIds.HasTypeDefinition, Boolean.valueOf(false), Unsigned.uint((int)(NodeClass.ObjectType.getValue() | NodeClass.VariableType.getValue())), Unsigned.uint((int)BrowseResultMask.None.getValue()))).toArray(BrowseDescription[]::new);
        BrowseRequest browseRequest = new BrowseRequest(new RequestHeader(NodeId.NULL_VALUE, DateTime.now(), Unsigned.uint((int)0), Unsigned.uint((int)0), null, Unsigned.uint((int)0), null), new ViewDescription(NodeId.NULL_VALUE, DateTime.NULL_VALUE, Unsigned.uint((int)0)), Unsigned.uint((int)0), browseDescriptions);
        List<BrowseResult> results = BrowseHelper.browse(this.server, () -> Optional.of(this.session), browseRequest);
        HashMap<NodeId, NodeId> typeDefinitions = new HashMap<NodeId, NodeId>();
        for (int i = 0; i < results.size(); ++i) {
            Optional targetId;
            ReferenceDescription[] references;
            BrowseResult result = results.get(i);
            if (!result.getStatusCode().isGood() || result.getReferences() == null || (references = result.getReferences()).length <= 0 || !(targetId = references[0].getNodeId().toNodeId(this.server.getNamespaceTable())).isPresent()) continue;
            typeDefinitions.put(nodeIds.get(i), (NodeId)targetId.get());
        }
        return typeDefinitions;
    }

    private boolean isAnalogItemType(NodeId typeDefinitionId) {
        return typeDefinitionId.equals((Object)NodeIds.AnalogItemType) || this.server.getVariableTypeTree().isSubtypeOf(typeDefinitionId, NodeIds.AnalogItemType);
    }

    private Map<NodeId, Range> readEURanges(List<NodeId> analogItemNodeIds) {
        TranslateBrowsePathsToNodeIdsResponse response;
        if (analogItemNodeIds.isEmpty()) {
            return Collections.emptyMap();
        }
        BrowsePath[] browsePaths = (BrowsePath[])analogItemNodeIds.stream().map(this::createEURangeBrowsePath).toArray(BrowsePath[]::new);
        TranslateBrowsePathsToNodeIdsRequest request = new TranslateBrowsePathsToNodeIdsRequest(new RequestHeader(NodeId.NULL_VALUE, DateTime.now(), Unsigned.uint((int)0), Unsigned.uint((int)0), null, Unsigned.uint((int)0), null), browsePaths);
        try {
            BrowsePathsHelper helper = new BrowsePathsHelper(() -> Optional.of(this.session), this.server);
            response = helper.translateBrowsePaths(request);
        }
        catch (UaException e) {
            this.logger.warn("Failed to translate EURange browse paths", (Throwable)e);
            return Collections.emptyMap();
        }
        ArrayList<NodeId> euRangeNodeIds = new ArrayList<NodeId>();
        HashMap<Integer, NodeId> nodeIdMapping = new HashMap<Integer, NodeId>();
        for (int i = 0; i < Objects.requireNonNull(response.getResults()).length; ++i) {
            BrowsePathTarget target;
            Optional euRangeNodeId;
            BrowsePathResult result = response.getResults()[i];
            if (!result.getStatusCode().isGood() || Objects.requireNonNull(result.getTargets()).length <= 0 || !(euRangeNodeId = (target = result.getTargets()[0]).getTargetId().toNodeId(this.server.getNamespaceTable())).isPresent()) continue;
            nodeIdMapping.put(euRangeNodeIds.size(), analogItemNodeIds.get(i));
            euRangeNodeIds.add((NodeId)euRangeNodeId.get());
        }
        if (euRangeNodeIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<ReadValueId> readValueIds = euRangeNodeIds.stream().map(id -> new ReadValueId(id, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)).toList();
        AddressSpace.ReadContext context = new AddressSpace.ReadContext(this.server, this.session);
        List<DataValue> values = this.server.getAddressSpaceManager().read(context, 0.0, TimestampsToReturn.Neither, readValueIds);
        HashMap<NodeId, Range> euRanges = new HashMap<NodeId, Range>();
        for (int i = 0; i < values.size(); ++i) {
            Object rangeObj;
            DataValue value = values.get(i);
            if (!value.getStatusCode().isGood() || !value.getValue().isNotNull() || !((rangeObj = value.getValue().getValue()) instanceof Range)) continue;
            Range range = (Range)rangeObj;
            NodeId originalNodeId = (NodeId)nodeIdMapping.get(i);
            euRanges.put(originalNodeId, range);
        }
        return euRanges;
    }

    private BrowsePath createEURangeBrowsePath(NodeId startNodeId) {
        RelativePathElement element = new RelativePathElement(NodeIds.HasProperty, Boolean.valueOf(false), Boolean.valueOf(true), EU_RANGE_BROWSE_NAME);
        return new BrowsePath(startNodeId, new RelativePath(new RelativePathElement[]{element}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<DeleteMonitoredItemsResponse> deleteMonitoredItems(ServiceRequestContext context, DeleteMonitoredItemsRequest request) {
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        UInteger[] itemsToDelete = request.getMonitoredItemIds();
        if (subscription == null) {
            return FutureUtils.failedUaFuture((long)0x80280000L);
        }
        if (itemsToDelete == null || itemsToDelete.length == 0) {
            return FutureUtils.failedUaFuture((long)0x800F0000L);
        }
        StatusCode[] deleteResults = new StatusCode[itemsToDelete.length];
        ArrayList deletedItems = new ArrayList(itemsToDelete.length);
        Subscription subscription2 = subscription;
        synchronized (subscription2) {
            for (int i = 0; i < itemsToDelete.length; ++i) {
                UInteger itemId = itemsToDelete[i];
                BaseMonitoredItem<?> item = subscription.getMonitoredItems().get(itemId);
                if (item == null) {
                    deleteResults[i] = new StatusCode(2151809024L);
                    continue;
                }
                deletedItems.add(item);
                deleteResults[i] = StatusCode.GOOD;
                this.monitoredItemCount.decrementAndGet();
                this.server.getMonitoredItemCount().decrementAndGet();
            }
            subscription.removeMonitoredItems(deletedItems);
        }
        SubscriptionManager.byMonitoredItemType(deletedItems, dataItems -> this.server.getAddressSpaceManager().onDataItemsDeleted((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsDeleted((List<EventItem>)eventItems));
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        DeleteMonitoredItemsResponse response = new DeleteMonitoredItemsResponse(header, deleteResults, new DiagnosticInfo[0]);
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<SetMonitoringModeResponse> setMonitoringMode(ServiceRequestContext context, SetMonitoringModeRequest request) {
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        UInteger[] itemsToModify = request.getMonitoredItemIds();
        if (subscription == null) {
            return FutureUtils.failedUaFuture((long)0x80280000L);
        }
        if (itemsToModify == null || itemsToModify.length == 0) {
            return FutureUtils.failedUaFuture((long)0x800F0000L);
        }
        MonitoringMode monitoringMode = request.getMonitoringMode();
        StatusCode[] results = new StatusCode[itemsToModify.length];
        ArrayList<MonitoredItem> modified = new ArrayList<MonitoredItem>(itemsToModify.length);
        for (int i = 0; i < itemsToModify.length; ++i) {
            UInteger itemId = itemsToModify[i];
            BaseMonitoredItem<?> item = subscription.getMonitoredItems().get(itemId);
            if (item != null) {
                item.setMonitoringMode(monitoringMode);
                modified.add(item);
                results[i] = StatusCode.GOOD;
                continue;
            }
            results[i] = new StatusCode(2151809024L);
        }
        this.server.getAddressSpaceManager().onMonitoringModeChanged(modified);
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        SetMonitoringModeResponse response = new SetMonitoringModeResponse(header, results, new DiagnosticInfo[0]);
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<PublishResponse> publish(ServiceRequestContext context, PublishRequest request) {
        StatusCode[] results;
        SubscriptionAcknowledgement[] acknowledgements = request.getSubscriptionAcknowledgements();
        if (acknowledgements != null) {
            results = new StatusCode[acknowledgements.length];
            for (int i = 0; i < acknowledgements.length; ++i) {
                SubscriptionAcknowledgement acknowledgement = acknowledgements[i];
                UInteger sequenceNumber = acknowledgement.getSequenceNumber();
                UInteger subscriptionId = acknowledgement.getSubscriptionId();
                Subscription subscription = this.subscriptions.get(subscriptionId);
                if (subscription == null) {
                    this.logger.debug("Can't acknowledge sequenceNumber={} on subscriptionId={}; id not valid for this session", (Object)sequenceNumber, (Object)subscriptionId);
                    results[i] = new StatusCode(0x80280000L);
                    continue;
                }
                this.logger.debug("Acknowledging sequenceNumber={} on subscriptionId={}", (Object)sequenceNumber, (Object)subscriptionId);
                results[i] = subscription.acknowledge(sequenceNumber);
            }
        } else {
            results = new StatusCode[]{};
        }
        PublishQueue.PendingPublish pending = new PublishQueue.PendingPublish(context, request, results);
        if (!this.transferred.isEmpty()) {
            Subscription subscription = this.transferred.remove(0);
            subscription.publishStatusChangeNotification(pending, new StatusCode(0x2D0000L));
        } else if (this.subscriptions.isEmpty() && this.publishQueue.isWaitListEmpty()) {
            pending.responseFuture.completeExceptionally(new UaException(2155413504L));
        } else {
            this.publishQueue.addRequest(pending);
        }
        return pending.responseFuture;
    }

    public CompletableFuture<RepublishResponse> republish(RepublishRequest request) {
        if (this.subscriptions.isEmpty()) {
            return FutureUtils.failedUaFuture((long)0x80280000L);
        }
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        if (subscription == null) {
            return FutureUtils.failedUaFuture((long)0x80280000L);
        }
        UInteger sequenceNumber = request.getRetransmitSequenceNumber();
        NotificationMessage notificationMessage = subscription.republish(sequenceNumber);
        if (notificationMessage == null) {
            return FutureUtils.failedUaFuture((long)2155544576L);
        }
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        RepublishResponse response = new RepublishResponse(header, notificationMessage);
        return CompletableFuture.completedFuture(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<SetTriggeringResponse> setTriggering(ServiceRequestContext context, SetTriggeringRequest request) {
        StatusCode[] addResults;
        StatusCode[] removeResults;
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        if (subscription == null) {
            return FutureUtils.failedUaFuture((long)0x80280000L);
        }
        UInteger triggerId = request.getTriggeringItemId();
        UInteger[] linksToAdd = Objects.requireNonNullElse(request.getLinksToAdd(), new UInteger[0]);
        UInteger[] linksToRemove = Objects.requireNonNullElse(request.getLinksToRemove(), new UInteger[0]);
        if (linksToAdd.length == 0 && linksToRemove.length == 0) {
            return FutureUtils.failedUaFuture((long)0x800F0000L);
        }
        Subscription subscription2 = subscription;
        synchronized (subscription2) {
            Map<UInteger, BaseMonitoredItem<?>> itemsById = subscription.getMonitoredItems();
            BaseMonitoredItem<?> triggerItem = itemsById.get(triggerId);
            if (triggerItem == null) {
                return FutureUtils.failedUaFuture((long)2151809024L);
            }
            removeResults = (StatusCode[])Stream.of(linksToRemove).map(linkedItemId -> {
                BaseMonitoredItem item = (BaseMonitoredItem)itemsById.get(linkedItemId);
                if (item != null) {
                    if (triggerItem.getTriggeredItems().remove(linkedItemId) != null) {
                        return StatusCode.GOOD;
                    }
                    return new StatusCode(2151809024L);
                }
                return new StatusCode(2151809024L);
            }).toArray(StatusCode[]::new);
            addResults = (StatusCode[])Stream.of(linksToAdd).map(linkedItemId -> {
                BaseMonitoredItem linkedItem = (BaseMonitoredItem)itemsById.get(linkedItemId);
                if (linkedItem != null) {
                    triggerItem.getTriggeredItems().put((UInteger)linkedItemId, linkedItem);
                    return StatusCode.GOOD;
                }
                return new StatusCode(2151809024L);
            }).toArray(StatusCode[]::new);
        }
        SetTriggeringResponse response = new SetTriggeringResponse(AbstractServiceSet.createResponseHeader((UaRequestMessageType)request), addResults, new DiagnosticInfo[0], removeResults, new DiagnosticInfo[0]);
        return CompletableFuture.completedFuture(response);
    }

    public void sessionClosed(boolean deleteSubscriptions) {
        Iterator<Subscription> iterator = this.subscriptions.values().iterator();
        while (iterator.hasNext()) {
            Subscription s = iterator.next();
            s.setStateListener(null);
            if (deleteSubscriptions) {
                this.server.getSubscriptions().remove(s.getId());
                this.server.getInternalEventBus().post((Object)new SubscriptionDeletedEvent(s));
                List<BaseMonitoredItem<?>> deletedItems = s.deleteSubscription();
                SubscriptionManager.byMonitoredItemType(deletedItems, dataItems -> this.server.getAddressSpaceManager().onDataItemsDeleted((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsDeleted((List<EventItem>)eventItems));
                this.monitoredItemCount.getAndUpdate(count -> count - (long)deletedItems.size());
                this.server.getMonitoredItemCount().getAndUpdate(count -> count - (long)deletedItems.size());
            }
            iterator.remove();
        }
        if (deleteSubscriptions) {
            while (this.publishQueue.isNotEmpty()) {
                PublishQueue.PendingPublish pending = this.publishQueue.poll();
                if (pending == null) continue;
                pending.responseFuture.completeExceptionally(new UaException(2149974016L));
            }
        }
    }

    public void addSubscription(Subscription subscription) {
        this.subscriptions.put(subscription.getId(), subscription);
        this.server.getInternalEventBus().post((Object)new SubscriptionCreatedEvent(subscription));
        subscription.setStateListener((s, ps, cs) -> {
            if (cs == Subscription.State.Closing) {
                this.subscriptions.remove(s.getId());
                this.server.getSubscriptions().remove(s.getId());
                this.server.getInternalEventBus().post((Object)new SubscriptionDeletedEvent(s));
                Map<UInteger, BaseMonitoredItem<?>> monitoredItems = s.getMonitoredItems();
                SubscriptionManager.byMonitoredItemType(monitoredItems.values(), dataItems -> this.server.getAddressSpaceManager().onDataItemsDeleted((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsDeleted((List<EventItem>)eventItems));
                this.monitoredItemCount.getAndUpdate(count -> count - (long)monitoredItems.size());
                this.server.getMonitoredItemCount().getAndUpdate(count -> count - (long)monitoredItems.size());
                monitoredItems.clear();
            }
        });
    }

    public @Nullable Subscription removeSubscription(UInteger subscriptionId) {
        Subscription subscription = this.subscriptions.remove(subscriptionId);
        if (subscription != null) {
            this.server.getInternalEventBus().post((Object)new SubscriptionDeletedEvent(subscription));
            subscription.setStateListener(null);
            this.monitoredItemCount.getAndUpdate(count -> count - (long)subscription.getMonitoredItems().size());
        }
        return subscription;
    }

    public void sendStatusChangeNotification(Subscription subscription, StatusCode status) {
        PublishQueue.PendingPublish pending = this.publishQueue.poll();
        if (pending != null) {
            subscription.publishStatusChangeNotification(pending, status);
        } else {
            this.transferred.add(subscription);
        }
    }

    private static UInteger nextSubscriptionId() {
        return Unsigned.uint((long)SUBSCRIPTION_IDS.incrementAndGet());
    }

    private static void byMonitoredItemType(Collection<BaseMonitoredItem<?>> monitoredItems, Consumer<List<DataItem>> dataItemConsumer, Consumer<List<EventItem>> eventItemConsumer) {
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        ArrayList<EventItem> eventItems = new ArrayList<EventItem>();
        for (BaseMonitoredItem<?> item : monitoredItems) {
            if (item instanceof MonitoredDataItem) {
                dataItems.add((DataItem)((Object)item));
                continue;
            }
            if (!(item instanceof MonitoredEventItem)) continue;
            eventItems.add((EventItem)((Object)item));
        }
        try {
            if (!dataItems.isEmpty()) {
                dataItemConsumer.accept(dataItems);
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(SubscriptionManager.class).error("Uncaught Throwable in dataItemConsumer", t);
        }
        try {
            if (!eventItems.isEmpty()) {
                eventItemConsumer.accept(eventItems);
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(SubscriptionManager.class).error("Uncaught Throwable in eventItemConsumer", t);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface AttributesResponse {
    }

    private record MonitoringAttributes(@Nullable NodeClass nodeClass, @Nullable UByte eventNotifier, @Nullable NodeId dataType, @Nullable Double minimumSamplingInterval) implements AttributesResponse
    {
    }

    private record NegativeResponse(StatusCode statusCode) implements AttributesResponse
    {
    }

    private record AnalogItemAttributes(MonitoringAttributes monitoringAttributes, @Nullable Range euRange) implements AttributesResponse
    {
    }
}

