/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.servicesets;

import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public abstract class AbstractServiceSet {
    public static ResponseHeader createResponseHeader(UaRequestMessageType request) {
        return AbstractServiceSet.createResponseHeader(request, StatusCode.GOOD);
    }

    public static ResponseHeader createResponseHeader(UaRequestMessageType request, long statusCode) {
        return AbstractServiceSet.createResponseHeader(request, new StatusCode(statusCode));
    }

    public static ResponseHeader createResponseHeader(UaRequestMessageType request, StatusCode serviceResult) {
        return new ResponseHeader(DateTime.now(), request.getRequestHeader().getRequestHandle(), serviceResult, null, null, null);
    }

    public static ResponseHeader createResponseHeader(UaRequestMessageType request, DiagnosticInfo[] diagnosticInfos) {
        return AbstractServiceSet.createResponseHeader(request, StatusCode.GOOD);
    }
}

