/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.filters;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilterContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.jspecify.annotations.Nullable;

public final class AttributeFilters {
    private AttributeFilters() {
    }

    public static AttributeFilter getValue(final Function<AttributeFilterContext, DataValue> get) {
        return new AttributeFilter(){

            @Override
            public Object getAttribute(AttributeFilterContext ctx, AttributeId attributeId) {
                if (attributeId == AttributeId.Value) {
                    return get.apply(ctx);
                }
                return ctx.getAttribute(attributeId);
            }
        };
    }

    public static AttributeFilter setValue(final BiConsumer<AttributeFilterContext, DataValue> set) {
        return new AttributeFilter(){

            @Override
            public void setAttribute(AttributeFilterContext ctx, AttributeId attributeId, Object value) {
                if (attributeId == AttributeId.Value) {
                    set.accept(ctx, (DataValue)value);
                } else {
                    ctx.setAttribute(attributeId, value);
                }
            }
        };
    }

    public static AttributeFilter getSetValue(final Function<AttributeFilterContext, DataValue> get, final BiConsumer<AttributeFilterContext, DataValue> set) {
        return new AttributeFilter(){

            @Override
            public @Nullable Object getAttribute(AttributeFilterContext ctx, AttributeId attributeId) {
                if (attributeId == AttributeId.Value) {
                    return get.apply(ctx);
                }
                return ctx.getAttribute(attributeId);
            }

            @Override
            public void setAttribute(AttributeFilterContext ctx, AttributeId attributeId, @Nullable Object value) {
                if (attributeId == AttributeId.Value) {
                    set.accept(ctx, (DataValue)value);
                } else {
                    ctx.setAttribute(attributeId, value);
                }
            }
        };
    }
}

