/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.BrowsePath;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

class ReferenceTable {
    private final List<RefRow> references = new ArrayList<RefRow>();

    ReferenceTable() {
    }

    void addReference(BrowsePath sourcePath, NodeId referenceTypeId, ExpandedNodeId targetNodeId) {
        this.references.add(new RefRow(sourcePath, referenceTypeId, new RefTarget(targetNodeId)));
    }

    void addReference(BrowsePath sourcePath, NodeId referenceTypeId, BrowsePath targetPath) {
        this.references.add(new RefRow(sourcePath, referenceTypeId, new RefTarget(targetPath)));
    }

    List<RefRow> getReferences(BrowsePath sourcePath) {
        return this.references.stream().filter(t -> t.browsePath.equals(sourcePath)).collect(Collectors.toList());
    }

    static ReferenceTable merge(ReferenceTable table1, ReferenceTable table2) {
        ReferenceTable mergedTable = new ReferenceTable();
        mergedTable.references.addAll(table1.references);
        table2.references.forEach(row -> {
            BrowsePath browsePath = row.browsePath;
            NodeId referenceTypeId = row.nodeId;
            RefTarget target = row.target;
            if (NodeIds.HasProperty.equals((Object)referenceTypeId)) {
                boolean hasPropertyReference = mergedTable.references.stream().anyMatch(r -> r.browsePath.equals(browsePath) && r.nodeId.equals((Object)NodeIds.HasProperty) && r.target.equals(target));
                if (!hasPropertyReference) {
                    mergedTable.references.add((RefRow)row);
                }
            } else if (NodeIds.HasTypeDefinition.equals((Object)referenceTypeId)) {
                boolean hasTypeDefinitionReference = mergedTable.references.stream().anyMatch(r -> r.browsePath.equals(browsePath) && r.nodeId.equals((Object)NodeIds.HasTypeDefinition));
                if (!hasTypeDefinitionReference) {
                    mergedTable.references.add((RefRow)row);
                }
            } else if (!mergedTable.references.contains(row)) {
                mergedTable.references.add((RefRow)row);
            }
        });
        return mergedTable;
    }

    static class RefRow {
        final BrowsePath browsePath;
        final NodeId nodeId;
        final RefTarget target;

        RefRow(BrowsePath browsePath, NodeId nodeId, RefTarget target) {
            this.browsePath = browsePath;
            this.nodeId = nodeId;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RefRow row = (RefRow)o;
            return Objects.equals(this.browsePath, row.browsePath) && Objects.equals(this.nodeId, row.nodeId) && Objects.equals(this.target, row.target);
        }

        public int hashCode() {
            return Objects.hash(this.browsePath, this.nodeId, this.target);
        }
    }

    static class RefTarget {
        final ExpandedNodeId targetNodeId;
        final BrowsePath targetPath;

        RefTarget(ExpandedNodeId targetNodeId) {
            this.targetNodeId = targetNodeId;
            this.targetPath = null;
        }

        RefTarget(BrowsePath targetPath) {
            this.targetPath = targetPath;
            this.targetNodeId = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RefTarget target = (RefTarget)o;
            return Objects.equals(this.targetNodeId, target.targetNodeId) && Objects.equals(this.targetPath, target.targetPath);
        }

        public int hashCode() {
            return Objects.hash(this.targetNodeId, this.targetPath);
        }
    }
}

