/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.core.typetree.ReferenceTypeTree;
import org.eclipse.milo.opcua.sdk.server.AccessContext;
import org.eclipse.milo.opcua.sdk.server.NodeManager;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeObserver;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaServerNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilterChain;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.Matrix;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UNumber;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.jspecify.annotations.Nullable;

public abstract class UaNode
implements UaServerNode {
    private List<AttributeObserver> observers;
    final AttributeFilterChain filterChain = new AttributeFilterChain();
    private final UaNodeContext context;
    private NodeId nodeId;
    private NodeClass nodeClass;
    private QualifiedName browseName;
    private LocalizedText displayName;
    private LocalizedText description;
    private UInteger writeMask;
    private UInteger userWriteMask;
    private RolePermissionType[] rolePermissions;
    private RolePermissionType[] userRolePermissions;
    private AccessRestrictionType accessRestrictions;

    protected UaNode(UaNodeContext context, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        this(context, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, null, null, null);
    }

    protected UaNode(UaNodeContext context, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions) {
        this.context = context;
        this.nodeId = nodeId;
        this.nodeClass = nodeClass;
        this.browseName = browseName;
        this.displayName = displayName;
        this.description = description;
        this.writeMask = writeMask;
        this.userWriteMask = userWriteMask;
        this.rolePermissions = rolePermissions;
        this.userRolePermissions = userRolePermissions;
        this.accessRestrictions = accessRestrictions;
    }

    public NodeId getNodeId() {
        return (NodeId)this.filterChain.getAttribute(this, AttributeId.NodeId);
    }

    public NodeClass getNodeClass() {
        return (NodeClass)this.filterChain.getAttribute(this, AttributeId.NodeClass);
    }

    public QualifiedName getBrowseName() {
        return (QualifiedName)this.filterChain.getAttribute(this, AttributeId.BrowseName);
    }

    public LocalizedText getDisplayName() {
        return (LocalizedText)this.filterChain.getAttribute(this, AttributeId.DisplayName);
    }

    public LocalizedText getDescription() {
        return (LocalizedText)this.filterChain.getAttribute(this, AttributeId.Description);
    }

    public UInteger getWriteMask() {
        return (UInteger)this.filterChain.getAttribute(this, AttributeId.WriteMask);
    }

    public UInteger getUserWriteMask() {
        return (UInteger)this.filterChain.getAttribute(this, AttributeId.UserWriteMask);
    }

    public RolePermissionType[] getRolePermissions() {
        return (RolePermissionType[])this.filterChain.getAttribute(this, AttributeId.RolePermissions);
    }

    public RolePermissionType[] getUserRolePermissions() {
        return (RolePermissionType[])this.filterChain.getAttribute(this, AttributeId.UserRolePermissions);
    }

    public AccessRestrictionType getAccessRestrictions() {
        return (AccessRestrictionType)this.filterChain.getAttribute(this, AttributeId.AccessRestrictions);
    }

    public void setNodeId(NodeId nodeId) {
        this.filterChain.setAttribute(this, AttributeId.NodeId, nodeId);
    }

    public void setNodeClass(NodeClass nodeClass) {
        this.filterChain.setAttribute(this, AttributeId.NodeClass, nodeClass);
    }

    public void setBrowseName(QualifiedName browseName) {
        this.filterChain.setAttribute(this, AttributeId.BrowseName, browseName);
    }

    public void setDisplayName(LocalizedText displayName) {
        this.filterChain.setAttribute(this, AttributeId.DisplayName, displayName);
    }

    public void setDescription(LocalizedText description) {
        this.filterChain.setAttribute(this, AttributeId.Description, description);
    }

    public void setWriteMask(UInteger writeMask) {
        this.filterChain.setAttribute(this, AttributeId.WriteMask, writeMask);
    }

    public void setUserWriteMask(UInteger userWriteMask) {
        this.filterChain.setAttribute(this, AttributeId.UserWriteMask, userWriteMask);
    }

    public void setRolePermissions(RolePermissionType[] rolePermissions) {
        this.filterChain.setAttribute(this, AttributeId.RolePermissions, rolePermissions);
    }

    public void setUserRolePermissions(RolePermissionType[] userRolePermissions) {
        this.filterChain.setAttribute(this, AttributeId.UserRolePermissions, userRolePermissions);
    }

    public void setAccessRestrictions(AccessRestrictionType accessRestrictions) {
        this.filterChain.setAttribute(this, AttributeId.AccessRestrictions, accessRestrictions);
    }

    public synchronized Object getAttribute(AttributeId attributeId) {
        return switch (attributeId) {
            case AttributeId.NodeId -> this.nodeId;
            case AttributeId.NodeClass -> this.nodeClass;
            case AttributeId.BrowseName -> this.browseName;
            case AttributeId.DisplayName -> this.displayName;
            case AttributeId.Description -> this.description;
            case AttributeId.WriteMask -> this.writeMask;
            case AttributeId.UserWriteMask -> this.userWriteMask;
            case AttributeId.RolePermissions -> this.rolePermissions;
            case AttributeId.UserRolePermissions -> this.userRolePermissions;
            case AttributeId.AccessRestrictions -> this.accessRestrictions;
            default -> throw new UaRuntimeException(2150957056L, "AttributeId: " + String.valueOf(attributeId));
        };
    }

    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        switch (attributeId) {
            case NodeId: {
                this.nodeId = (NodeId)value;
                break;
            }
            case NodeClass: {
                this.nodeClass = (NodeClass)value;
                break;
            }
            case BrowseName: {
                this.browseName = (QualifiedName)value;
                break;
            }
            case DisplayName: {
                this.displayName = (LocalizedText)value;
                break;
            }
            case Description: {
                this.description = (LocalizedText)value;
                break;
            }
            case WriteMask: {
                this.writeMask = (UInteger)value;
                break;
            }
            case UserWriteMask: {
                this.userWriteMask = (UInteger)value;
                break;
            }
            case RolePermissions: {
                this.rolePermissions = (RolePermissionType[])value;
                break;
            }
            case UserRolePermissions: {
                this.userRolePermissions = (RolePermissionType[])value;
                break;
            }
            case AccessRestrictions: {
                this.accessRestrictions = (AccessRestrictionType)value;
                break;
            }
            default: {
                throw new UaRuntimeException(2150957056L, "AttributeId: " + String.valueOf(attributeId));
            }
        }
        this.fireAttributeChanged(attributeId, value);
    }

    public final void delete() {
        NodeManager<UaNode> nodeManager = this.context.getNodeManager();
        ReferenceTypeTree referenceTypeTree = this.context.getServer().getReferenceTypeTree();
        nodeManager.removeNode((UaNode)this.getNodeId());
        for (Reference reference : nodeManager.getReferences(this.getNodeId())) {
            if (reference.isForward() && referenceTypeTree.isSubtypeOf(reference.getReferenceTypeId(), NodeIds.HasChild)) {
                Optional<UaNode> targetNode = nodeManager.getNode(reference.getTargetNodeId(), this.getNodeContext().getServer().getNamespaceTable());
                targetNode.ifPresent(UaNode::delete);
            }
            nodeManager.removeReferences(reference, this.context.getNamespaceTable());
        }
    }

    @Override
    public final UaNodeContext getNodeContext() {
        return this.context;
    }

    public final NodeManager<UaNode> getNodeManager() {
        return this.context.getNodeManager();
    }

    protected Optional<UaNode> getManagedNode(NodeId nodeId) {
        return this.context.getServer().getAddressSpaceManager().getManagedNode(nodeId);
    }

    protected Optional<UaNode> getManagedNode(ExpandedNodeId nodeId) {
        return this.context.getServer().getAddressSpaceManager().getManagedNode(nodeId);
    }

    @Override
    public List<Reference> getReferences() {
        return List.copyOf(this.context.getServer().getAddressSpaceManager().getManagedReferences(this.getNodeId()));
    }

    @Override
    public void addReference(Reference reference) {
        this.context.getNodeManager().addReferences(reference, this.context.getNamespaceTable());
    }

    @Override
    public void removeReference(Reference reference) {
        this.context.getNodeManager().removeReferences(reference, this.context.getNamespaceTable());
    }

    public <T> Optional<T> getProperty(QualifiedProperty<T> property) {
        String namespaceUri = property.getNamespaceUri();
        UShort namespaceIndex = (UShort)this.context.getServer().getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            QualifiedName browseName = new QualifiedName(namespaceIndex, property.getBrowseName());
            try {
                Matrix matrix;
                Object v = this.getProperty(browseName).orElse(null);
                if (v instanceof ExtensionObject) {
                    ExtensionObject xo = (ExtensionObject)v;
                    v = xo.decode(this.context.getServer().getStaticEncodingContext());
                } else if (v instanceof ExtensionObject[]) {
                    ExtensionObject[] xos = (ExtensionObject[])v;
                    Object array = Array.newInstance(property.getJavaType().getComponentType(), xos.length);
                    for (int i = 0; i < xos.length; ++i) {
                        Array.set(array, i, xos[i].decode(this.context.getServer().getStaticEncodingContext()));
                    }
                    v = array;
                } else if (v instanceof Matrix && (matrix = (Matrix)v).getElements() instanceof ExtensionObject[]) {
                    v = matrix.transform(e -> {
                        if (e instanceof ExtensionObject) {
                            ExtensionObject xo = (ExtensionObject)e;
                            return xo.decode(this.context.getServer().getStaticEncodingContext());
                        }
                        return e;
                    });
                }
                return Optional.ofNullable(property.getJavaType().cast(v));
            }
            catch (Throwable t) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Object> getProperty(QualifiedName browseName) {
        return this.getPropertyNode(browseName).map(node -> node.getValue().value().value());
    }

    public <T> void setProperty(QualifiedProperty<T> property, T value) {
        UShort namespaceIndex = (UShort)this.context.getServer().getNamespaceTable().getIndex(property.getNamespaceUri());
        if (namespaceIndex == null) {
            throw new IllegalArgumentException("property belongs to unregistered namespace: " + property.getNamespaceUri());
        }
        VariableNode node = this.getPropertyNode(property).orElseGet(() -> {
            String browseName = property.getBrowseName();
            NodeId propertyNodeId = new NodeId(this.getNodeId().getNamespaceIndex(), String.format("%s.%s", this.getNodeId().getIdentifier().toString(), browseName));
            PropertyTypeNode propertyNode = new PropertyTypeNode(this.context, propertyNodeId, new QualifiedName(namespaceIndex, browseName), LocalizedText.english((String)browseName), LocalizedText.NULL_VALUE, Unsigned.uint((int)0), Unsigned.uint((int)0), null, null, null, UaVariableNode.INITIAL_VALUE, NodeIds.BaseDataType, -1, null);
            NodeId dataType = property.getDataType().toNodeId(this.context.getNamespaceTable()).orElse(NodeId.NULL_VALUE);
            propertyNode.setDataType(dataType);
            propertyNode.setValueRank(property.getValueRank());
            propertyNode.setArrayDimensions(property.getArrayDimensions());
            propertyNode.addReference(new Reference(propertyNode.getNodeId(), NodeIds.HasTypeDefinition, NodeIds.PropertyType.expanded(), true));
            this.addProperty(propertyNode);
            this.context.getNodeManager().addNode(propertyNode);
            return propertyNode;
        });
        node.setValue(new DataValue(new Variant(value)));
    }

    public Optional<VariableNode> getPropertyNode(QualifiedProperty<?> property) {
        Optional qualifiedName = property.getQualifiedName(this.context.getServer().getNamespaceTable());
        return qualifiedName.map(this::getPropertyNode).orElseGet(() -> this.getPropertyNode(property.getBrowseName()));
    }

    public Optional<VariableNode> getPropertyNode(String browseName) {
        return this.getPropertyNode(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    public Optional<VariableNode> getPropertyNode(QualifiedName browseName) {
        Node node = this.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> this.getManagedNode(r.getTargetNodeId()).stream()).filter(n -> n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        try {
            return Optional.ofNullable((VariableNode)node);
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    void addProperty(UaVariableNode node) {
        this.addReference(new Reference(this.getNodeId(), NodeIds.HasProperty, node.getNodeId().expanded(), true));
        node.addReference(new Reference(node.getNodeId(), NodeIds.HasProperty, this.getNodeId().expanded(), false));
    }

    void removeProperty(UaVariableNode node) {
        this.removeReference(new Reference(this.getNodeId(), NodeIds.HasProperty, node.getNodeId().expanded(), true));
        node.removeReference(new Reference(node.getNodeId(), NodeIds.HasProperty, this.getNodeId().expanded(), false));
    }

    public Optional<UaNode> findNode(QualifiedName browseName) {
        return this.findNode(browseName, uaNode -> true, reference -> true);
    }

    public Optional<UaNode> findNode(QualifiedName browseName, Predicate<Reference> references) {
        return this.findNode(browseName, uaNode -> true, references);
    }

    public Optional<UaNode> findNode(QualifiedName browseName, Predicate<UaNode> nodePredicate, Predicate<Reference> referencePredicate) {
        return this.getReferences().stream().filter(referencePredicate).flatMap(r -> this.getManagedNode(r.getTargetNodeId()).stream()).filter(nodePredicate).filter(n -> n.getBrowseName().equals((Object)browseName)).findFirst();
    }

    public Optional<UaNode> findNode(String namespaceUri, String browseName, Predicate<UaNode> nodePredicate, Predicate<Reference> referencePredicate) {
        return this.getReferences().stream().filter(referencePredicate).flatMap(r -> this.getManagedNode(r.getTargetNodeId()).stream()).filter(nodePredicate).filter(n -> {
            String nodeBrowseName = n.getBrowseName().name();
            UShort index = n.getBrowseName().namespaceIndex();
            String nodeBrowseNameUri = this.context.getServer().getNamespaceTable().get((UNumber)index);
            return Objects.equals(browseName, nodeBrowseName) && Objects.equals(namespaceUri, nodeBrowseNameUri);
        }).findFirst();
    }

    protected Optional<ObjectNode> getObjectComponent(String namespaceUri, String name) {
        UShort namespaceIndex = (UShort)this.context.getServer().getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getObjectComponent(new QualifiedName(namespaceIndex, name));
        }
        return Optional.empty();
    }

    protected Optional<ObjectNode> getObjectComponent(String browseName) {
        return this.getObjectComponent(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    protected Optional<ObjectNode> getObjectComponent(QualifiedName browseName) {
        ObjectNode node = this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> this.getManagedNode(r.getTargetNodeId()).stream()).filter(n -> n.getNodeClass() == NodeClass.Object && n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        return Optional.ofNullable(node);
    }

    protected Optional<VariableNode> getVariableComponent(String namespaceUri, String name) {
        UShort namespaceIndex = (UShort)this.context.getServer().getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getVariableComponent(new QualifiedName(namespaceIndex, name));
        }
        return Optional.empty();
    }

    protected Optional<VariableNode> getVariableComponent(String browseName) {
        return this.getVariableComponent(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    protected Optional<VariableNode> getVariableComponent(QualifiedName browseName) {
        VariableNode node = this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> this.getManagedNode(r.getTargetNodeId()).stream()).filter(n -> n.getNodeClass() == NodeClass.Variable && n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        return Optional.ofNullable(node);
    }

    public synchronized void addAttributeObserver(AttributeObserver observer) {
        if (this.observers == null) {
            this.observers = new LinkedList<AttributeObserver>();
        }
        this.observers.add(observer);
    }

    public synchronized void removeAttributeObserver(AttributeObserver observer) {
        if (this.observers == null) {
            return;
        }
        this.observers.remove(observer);
        if (this.observers.isEmpty()) {
            this.observers = null;
        }
    }

    public synchronized void fireAttributeChanged(AttributeId attributeId, Object attributeValue) {
        if (this.observers == null) {
            return;
        }
        ArrayList<AttributeObserver> toNotify = new ArrayList<AttributeObserver>(this.observers);
        toNotify.forEach(o -> o.attributeChanged(this, attributeId, attributeValue));
    }

    public AttributeFilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    public @Nullable Object getAttribute(AccessContext context, AttributeId attributeId) {
        return this.getFilterChain().getAttribute(context.getSession().orElse(null), this, attributeId);
    }

    @Override
    public @Nullable Object readAttribute(AccessContext context, AttributeId attributeId) throws UaException {
        return this.getFilterChain().readAttribute(context.getSession().orElse(null), this, attributeId);
    }

    @Override
    public void setAttribute(AccessContext context, AttributeId attributeId, @Nullable Object value) {
        this.getFilterChain().setAttribute(context.getSession().orElse(null), this, attributeId, value);
    }

    @Override
    public void writeAttribute(AccessContext context, AttributeId attributeId, @Nullable Object value) throws UaException {
        this.getFilterChain().writeAttribute(context.getSession().orElse(null), this, attributeId, value);
    }
}

