/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.RationalNumberType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class RationalNumberTypeNode
extends BaseDataVariableTypeNode
implements RationalNumberType {
    public RationalNumberTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing, AccessLevelExType accessLevelEx) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    public RationalNumberTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions);
    }

    @Override
    public BaseDataVariableTypeNode getNumeratorNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "Numerator");
        return component.orElse(null);
    }

    @Override
    public Integer getNumerator() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "Numerator");
        return component.map(node -> (Integer)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setNumerator(Integer value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "Numerator").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public BaseDataVariableTypeNode getDenominatorNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "Denominator");
        return component.orElse(null);
    }

    @Override
    public UInteger getDenominator() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "Denominator");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setDenominator(UInteger value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "Denominator").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }
}

