/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.UnitType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class UnitTypeNode
extends BaseObjectTypeNode
implements UnitType {
    public UnitTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    public UnitTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
    }

    @Override
    public PropertyTypeNode getSymbolNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(UnitType.SYMBOL);
        return propertyNode.orElse(null);
    }

    @Override
    public LocalizedText getSymbol() {
        return this.getProperty(UnitType.SYMBOL).orElse(null);
    }

    @Override
    public void setSymbol(LocalizedText value) {
        this.setProperty(UnitType.SYMBOL, value);
    }

    @Override
    public PropertyTypeNode getUnitSystemNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(UnitType.UNIT_SYSTEM);
        return propertyNode.orElse(null);
    }

    @Override
    public String getUnitSystem() {
        return this.getProperty(UnitType.UNIT_SYSTEM).orElse(null);
    }

    @Override
    public void setUnitSystem(String value) {
        this.setProperty(UnitType.UNIT_SYSTEM, value);
    }

    @Override
    public PropertyTypeNode getDisciplineNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(UnitType.DISCIPLINE);
        return propertyNode.orElse(null);
    }

    @Override
    public String getDiscipline() {
        return this.getProperty(UnitType.DISCIPLINE).orElse(null);
    }

    @Override
    public void setDiscipline(String value) {
        this.setProperty(UnitType.DISCIPLINE, value);
    }
}

