/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.FileType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.TrustListValidationOptions;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface TrustListType
extends FileType {
    public static final QualifiedProperty<DateTime> LAST_UPDATE_TIME = new QualifiedProperty("http://opcfoundation.org/UA/", "LastUpdateTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=294"), Integer.valueOf(-1), DateTime.class);
    public static final QualifiedProperty<Double> UPDATE_FREQUENCY = new QualifiedProperty("http://opcfoundation.org/UA/", "UpdateFrequency", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=290"), Integer.valueOf(-1), Double.class);
    public static final QualifiedProperty<Double> ACTIVITY_TIMEOUT = new QualifiedProperty("http://opcfoundation.org/UA/", "ActivityTimeout", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=290"), Integer.valueOf(-1), Double.class);
    public static final QualifiedProperty<TrustListValidationOptions> DEFAULT_VALIDATION_OPTIONS = new QualifiedProperty("http://opcfoundation.org/UA/", "DefaultValidationOptions", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=23564"), Integer.valueOf(-1), TrustListValidationOptions.class);

    public DateTime getLastUpdateTime();

    public void setLastUpdateTime(DateTime var1);

    public PropertyType getLastUpdateTimeNode();

    public Double getUpdateFrequency();

    public void setUpdateFrequency(Double var1);

    public PropertyType getUpdateFrequencyNode();

    public Double getActivityTimeout();

    public void setActivityTimeout(Double var1);

    public PropertyType getActivityTimeoutNode();

    public TrustListValidationOptions getDefaultValidationOptions();

    public void setDefaultValidationOptions(TrustListValidationOptions var1);

    public PropertyType getDefaultValidationOptionsNode();

    public MethodNode getOpenWithMasksMethodNode();

    public MethodNode getCloseAndUpdateMethodNode();

    public MethodNode getAddCertificateMethodNode();

    public MethodNode getRemoveCertificateMethodNode();

    public static abstract class RemoveCertificateMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RemoveCertificateMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Thumbprint", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("IsTrustedCertificate", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String thumbprint = (String)inputValues[0].getValue();
            Boolean isTrustedCertificate = (Boolean)inputValues[1].getValue();
            this.invoke(context, thumbprint, isTrustedCertificate);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, Boolean var3) throws UaException;
    }

    public static abstract class AddCertificateMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public AddCertificateMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Certificate", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("IsTrustedCertificate", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ByteString certificate = (ByteString)inputValues[0].getValue();
            Boolean isTrustedCertificate = (Boolean)inputValues[1].getValue();
            this.invoke(context, certificate, isTrustedCertificate);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ByteString var2, Boolean var3) throws UaException;
    }

    public static abstract class CloseAndUpdateMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public CloseAndUpdateMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ApplyChangesRequired", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger fileHandle = (UInteger)inputValues[0].getValue();
            Out<Boolean> applyChangesRequired = new Out<Boolean>();
            this.invoke(context, fileHandle, applyChangesRequired);
            return new Variant[]{new Variant((Object)applyChangesRequired.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2, Out<Boolean> var3) throws UaException;
    }

    public static abstract class OpenWithMasksMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public OpenWithMasksMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Masks", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger masks = (UInteger)inputValues[0].getValue();
            Out<UInteger> fileHandle = new Out<UInteger>();
            this.invoke(context, masks, fileHandle);
            return new Variant[]{new Variant((Object)fileHandle.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2, Out<UInteger> var3) throws UaException;
    }
}

