/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectType;
import org.eclipse.milo.opcua.sdk.server.model.objects.CertificateGroupFolderType;
import org.eclipse.milo.opcua.sdk.server.model.objects.TransactionDiagnosticsType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface ServerConfigurationType
extends BaseObjectType {
    public static final QualifiedProperty<String> APPLICATION_URI = new QualifiedProperty("http://opcfoundation.org/UA/", "ApplicationUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=23751"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<String> PRODUCT_URI = new QualifiedProperty("http://opcfoundation.org/UA/", "ProductUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=23751"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<ApplicationType> APPLICATION_TYPE = new QualifiedProperty("http://opcfoundation.org/UA/", "ApplicationType", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=307"), Integer.valueOf(-1), ApplicationType.class);
    public static final QualifiedProperty<LocalizedText[]> APPLICATION_NAMES = new QualifiedProperty("http://opcfoundation.org/UA/", "ApplicationNames", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=21"), Integer.valueOf(1), LocalizedText[].class);
    public static final QualifiedProperty<String[]> SERVER_CAPABILITIES = new QualifiedProperty("http://opcfoundation.org/UA/", "ServerCapabilities", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(1), String[].class);
    public static final QualifiedProperty<String[]> SUPPORTED_PRIVATE_KEY_FORMATS = new QualifiedProperty("http://opcfoundation.org/UA/", "SupportedPrivateKeyFormats", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(1), String[].class);
    public static final QualifiedProperty<UInteger> MAX_TRUST_LIST_SIZE = new QualifiedProperty("http://opcfoundation.org/UA/", "MaxTrustListSize", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7"), Integer.valueOf(-1), UInteger.class);
    public static final QualifiedProperty<Boolean> MULTICAST_DNS_ENABLED = new QualifiedProperty("http://opcfoundation.org/UA/", "MulticastDnsEnabled", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);
    public static final QualifiedProperty<Boolean> HAS_SECURE_ELEMENT = new QualifiedProperty("http://opcfoundation.org/UA/", "HasSecureElement", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);
    public static final QualifiedProperty<Boolean> SUPPORTS_TRANSACTIONS = new QualifiedProperty("http://opcfoundation.org/UA/", "SupportsTransactions", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);
    public static final QualifiedProperty<Boolean> IN_APPLICATION_SETUP = new QualifiedProperty("http://opcfoundation.org/UA/", "InApplicationSetup", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);

    public String getApplicationUri();

    public void setApplicationUri(String var1);

    public PropertyType getApplicationUriNode();

    public String getProductUri();

    public void setProductUri(String var1);

    public PropertyType getProductUriNode();

    public ApplicationType getApplicationType();

    public void setApplicationType(ApplicationType var1);

    public PropertyType getApplicationTypeNode();

    public LocalizedText[] getApplicationNames();

    public void setApplicationNames(LocalizedText[] var1);

    public PropertyType getApplicationNamesNode();

    public String[] getServerCapabilities();

    public void setServerCapabilities(String[] var1);

    public PropertyType getServerCapabilitiesNode();

    public String[] getSupportedPrivateKeyFormats();

    public void setSupportedPrivateKeyFormats(String[] var1);

    public PropertyType getSupportedPrivateKeyFormatsNode();

    public UInteger getMaxTrustListSize();

    public void setMaxTrustListSize(UInteger var1);

    public PropertyType getMaxTrustListSizeNode();

    public Boolean getMulticastDnsEnabled();

    public void setMulticastDnsEnabled(Boolean var1);

    public PropertyType getMulticastDnsEnabledNode();

    public Boolean getHasSecureElement();

    public void setHasSecureElement(Boolean var1);

    public PropertyType getHasSecureElementNode();

    public Boolean getSupportsTransactions();

    public void setSupportsTransactions(Boolean var1);

    public PropertyType getSupportsTransactionsNode();

    public Boolean getInApplicationSetup();

    public void setInApplicationSetup(Boolean var1);

    public PropertyType getInApplicationSetupNode();

    public CertificateGroupFolderType getCertificateGroupsNode();

    public MethodNode getUpdateCertificateMethodNode();

    public MethodNode getGetCertificatesMethodNode();

    public MethodNode getApplyChangesMethodNode();

    public MethodNode getCancelChangesMethodNode();

    public MethodNode getCreateSigningRequestMethodNode();

    public MethodNode getGetRejectedListMethodNode();

    public MethodNode getResetToServerDefaultsMethodNode();

    public TransactionDiagnosticsType getTransactionDiagnosticsNode();

    public static abstract class ResetToServerDefaultsMethod
    extends AbstractMethodInvocationHandler {
        public ResetToServerDefaultsMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return new Argument[0];
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            this.invoke(context);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1) throws UaException;
    }

    public static abstract class GetRejectedListMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public GetRejectedListMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return new Argument[0];
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Certificates", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            Out<ByteString[]> certificates = new Out<ByteString[]>();
            this.invoke(context, certificates);
            return new Variant[]{new Variant((Object)certificates.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, Out<ByteString[]> var2) throws UaException;
    }

    public static abstract class CreateSigningRequestMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public CreateSigningRequestMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("CertificateGroupId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("CertificateTypeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("SubjectName", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("RegeneratePrivateKey", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Nonce", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("CertificateRequest", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            NodeId certificateGroupId = (NodeId)inputValues[0].getValue();
            NodeId certificateTypeId = (NodeId)inputValues[1].getValue();
            String subjectName = (String)inputValues[2].getValue();
            Boolean regeneratePrivateKey = (Boolean)inputValues[3].getValue();
            ByteString nonce = (ByteString)inputValues[4].getValue();
            Out<ByteString> certificateRequest = new Out<ByteString>();
            this.invoke(context, certificateGroupId, certificateTypeId, subjectName, regeneratePrivateKey, nonce, certificateRequest);
            return new Variant[]{new Variant((Object)certificateRequest.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, NodeId var2, NodeId var3, String var4, Boolean var5, ByteString var6, Out<ByteString> var7) throws UaException;
    }

    public static abstract class CancelChangesMethod
    extends AbstractMethodInvocationHandler {
        public CancelChangesMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return new Argument[0];
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            this.invoke(context);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1) throws UaException;
    }

    public static abstract class ApplyChangesMethod
    extends AbstractMethodInvocationHandler {
        public ApplyChangesMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return new Argument[0];
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            this.invoke(context);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1) throws UaException;
    }

    public static abstract class GetCertificatesMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public GetCertificatesMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("CertificateGroupId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("CertificateTypeIds", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("Certificates", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            NodeId certificateGroupId = (NodeId)inputValues[0].getValue();
            Out<NodeId[]> certificateTypeIds = new Out<NodeId[]>();
            Out<ByteString[]> certificates = new Out<ByteString[]>();
            this.invoke(context, certificateGroupId, certificateTypeIds, certificates);
            return new Variant[]{new Variant((Object)certificateTypeIds.get()), new Variant((Object)certificates.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, NodeId var2, Out<NodeId[]> var3, Out<ByteString[]> var4) throws UaException;
    }

    public static abstract class UpdateCertificateMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public UpdateCertificateMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("CertificateGroupId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("CertificateTypeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Certificate", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("IssuerCertificates", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("PrivateKeyFormat", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("PrivateKey", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ApplyChangesRequired", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            NodeId certificateGroupId = (NodeId)inputValues[0].getValue();
            NodeId certificateTypeId = (NodeId)inputValues[1].getValue();
            ByteString certificate = (ByteString)inputValues[2].getValue();
            ByteString[] issuerCertificates = (ByteString[])inputValues[3].getValue();
            String privateKeyFormat = (String)inputValues[4].getValue();
            ByteString privateKey = (ByteString)inputValues[5].getValue();
            Out<Boolean> applyChangesRequired = new Out<Boolean>();
            this.invoke(context, certificateGroupId, certificateTypeId, certificate, issuerCertificates, privateKeyFormat, privateKey, applyChangesRequired);
            return new Variant[]{new Variant((Object)applyChangesRequired.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, NodeId var2, NodeId var3, ByteString var4, ByteString[] var5, String var6, ByteString var7, Out<Boolean> var8) throws UaException;
    }
}

