/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.PublishedDataSetType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.ConfigurationVersionDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface PublishedEventsType
extends PublishedDataSetType {
    public static final QualifiedProperty<NodeId> PUB_SUB_EVENT_NOTIFIER = new QualifiedProperty("http://opcfoundation.org/UA/", "EventNotifier", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17"), Integer.valueOf(-1), NodeId.class);
    public static final QualifiedProperty<SimpleAttributeOperand[]> SELECTED_FIELDS = new QualifiedProperty("http://opcfoundation.org/UA/", "SelectedFields", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=601"), Integer.valueOf(1), SimpleAttributeOperand[].class);
    public static final QualifiedProperty<ContentFilter> FILTER = new QualifiedProperty("http://opcfoundation.org/UA/", "Filter", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=586"), Integer.valueOf(-1), ContentFilter.class);

    public NodeId getPubSubEventNotifier();

    public void setPubSubEventNotifier(NodeId var1);

    public PropertyType getPubSubEventNotifierNode();

    public SimpleAttributeOperand[] getSelectedFields();

    public void setSelectedFields(SimpleAttributeOperand[] var1);

    public PropertyType getSelectedFieldsNode();

    public ContentFilter getFilter();

    public void setFilter(ContentFilter var1);

    public PropertyType getFilterNode();

    public MethodNode getModifyFieldSelectionMethodNode();

    public static abstract class ModifyFieldSelectionMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public ModifyFieldSelectionMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ConfigurationVersion", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14593").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("FieldNameAliases", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("PromotedFields", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("SelectedFields", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=601").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("NewConfigurationVersion", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14593").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ConfigurationVersionDataType configurationVersion = (ConfigurationVersionDataType)inputValues[0].getValue();
            String[] fieldNameAliases = (String[])inputValues[1].getValue();
            Boolean[] promotedFields = (Boolean[])inputValues[2].getValue();
            SimpleAttributeOperand[] selectedFields = (SimpleAttributeOperand[])inputValues[3].getValue();
            Out<ConfigurationVersionDataType> newConfigurationVersion = new Out<ConfigurationVersionDataType>();
            this.invoke(context, configurationVersion, fieldNameAliases, promotedFields, selectedFields, newConfigurationVersion);
            return new Variant[]{new Variant((Object)newConfigurationVersion.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ConfigurationVersionDataType var2, String[] var3, Boolean[] var4, SimpleAttributeOperand[] var5, Out<ConfigurationVersionDataType> var6) throws UaException;
    }
}

