/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubStatusType;
import org.eclipse.milo.opcua.sdk.server.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.PubSubState;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class PubSubStatusTypeNode
extends BaseObjectTypeNode
implements PubSubStatusType {
    public PubSubStatusTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    public PubSubStatusTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
    }

    @Override
    public BaseDataVariableTypeNode getStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "State");
        return component.orElse(null);
    }

    @Override
    public PubSubState getState() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "State");
        return component.map(node -> (PubSubState)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setState(PubSubState value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "State").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UaMethodNode getEnableMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Enable", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getDisableMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Disable", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }
}

