/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.operators;

import org.eclipse.milo.opcua.sdk.server.events.OperatorContext;
import org.eclipse.milo.opcua.sdk.server.events.operators.ImplicitConversionBinaryOperator;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.jspecify.annotations.Nullable;

public class LessThan
extends ImplicitConversionBinaryOperator<Boolean> {
    LessThan() {
    }

    @Override
    protected @Nullable Boolean apply(OperatorContext context, BaseEventTypeNode eventNode, OpcUaDataType dataType, @Nullable Object operand0, @Nullable Object operand1) {
        if (operand0 instanceof Number) {
            Number n0 = (Number)operand0;
            if (operand1 instanceof Number) {
                Number n1 = (Number)operand1;
                switch (dataType) {
                    case SByte: 
                    case Int16: 
                    case Int32: 
                    case Int64: 
                    case Byte: 
                    case UInt16: 
                    case UInt32: {
                        return n0.longValue() < n1.longValue();
                    }
                    case UInt64: {
                        return Long.compareUnsigned(n0.longValue(), n1.longValue()) < 0;
                    }
                    case Float: {
                        return n0.floatValue() < n1.floatValue();
                    }
                    case Double: {
                        return n0.doubleValue() < n1.doubleValue();
                    }
                }
                return false;
            }
        }
        return false;
    }
}

