/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class GuidConversions {
    private GuidConversions() {
    }

    static @NonNull ByteString guidToByteString(@NonNull UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return ByteString.of((byte[])bb.array());
    }

    static @NonNull String guidToString(@NonNull UUID uuid) {
        return uuid.toString();
    }

    static @Nullable Object convert(@NonNull Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            return implicit ? GuidConversions.implicitConversion(uuid, targetType) : GuidConversions.explicitConversion(uuid, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull UUID uuid, OpcUaDataType targetType) {
        switch (targetType) {
            case ByteString: {
                return GuidConversions.guidToByteString(uuid);
            }
            case String: {
                return GuidConversions.guidToString(uuid);
            }
        }
        return GuidConversions.implicitConversion(uuid, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull UUID uuid, OpcUaDataType targetType) {
        return null;
    }
}

