/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class FloatConversions {
    private FloatConversions() {
    }

    static @NonNull Boolean floatToBoolean(@NonNull Float f) {
        return f.floatValue() != 0.0f;
    }

    static @Nullable UByte floatToByte(@NonNull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= 0L && rounded <= 255L) {
            return Unsigned.ubyte((long)rounded);
        }
        return null;
    }

    static @NonNull Double floatToDouble(@NonNull Float f) {
        return f.doubleValue();
    }

    static @Nullable Short floatToInt16(@NonNull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= -32768L && rounded <= 32767L) {
            return (short)rounded;
        }
        return null;
    }

    static @NonNull Integer floatToInt32(@NonNull Float f) {
        return Math.round(f.floatValue());
    }

    static @NonNull Long floatToInt64(@NonNull Float f) {
        return Math.round(f.floatValue());
    }

    static @Nullable Byte floatToSByte(@NonNull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= -128L && rounded <= 127L) {
            return (byte)rounded;
        }
        return null;
    }

    static @NonNull String floatToString(@NonNull Float f) {
        return f.toString();
    }

    static @Nullable UShort floatToUInt16(@NonNull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= 0L && rounded <= 65535L) {
            return Unsigned.ushort((int)((int)rounded));
        }
        return null;
    }

    static @Nullable UInteger floatToUInt32(@NonNull Float f) {
        int rounded = Math.round(f.floatValue());
        if (rounded >= 0) {
            return Unsigned.uint((int)rounded);
        }
        return null;
    }

    static @Nullable ULong floatToUInt64(@NonNull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= 0L) {
            return Unsigned.ulong((long)rounded);
        }
        return null;
    }

    static @Nullable Object convert(@Nullable Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof Float) {
            Float f = (Float)o;
            return implicit ? FloatConversions.implicitConversion(f, targetType) : FloatConversions.explicitConversion(f, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull Float f, OpcUaDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return FloatConversions.floatToBoolean(f);
            }
            case Byte: {
                return FloatConversions.floatToByte(f);
            }
            case Int16: {
                return FloatConversions.floatToInt16(f);
            }
            case Int32: {
                return FloatConversions.floatToInt32(f);
            }
            case Int64: {
                return FloatConversions.floatToInt64(f);
            }
            case SByte: {
                return FloatConversions.floatToSByte(f);
            }
            case String: {
                return FloatConversions.floatToString(f);
            }
            case UInt16: {
                return FloatConversions.floatToUInt16(f);
            }
            case UInt32: {
                return FloatConversions.floatToUInt32(f);
            }
            case UInt64: {
                return FloatConversions.floatToUInt64(f);
            }
        }
        return FloatConversions.implicitConversion(f, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull Float f, OpcUaDataType targetType) {
        switch (targetType) {
            case Double: {
                return FloatConversions.floatToDouble(f);
            }
        }
        return null;
    }
}

