/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class ByteStringConversions {
    private ByteStringConversions() {
    }

    static @Nullable UUID byteStringToGuid(@NonNull ByteString bs) {
        if (bs.length() != 16) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bs.bytesOrEmpty());
        long high = byteBuffer.getLong();
        long low = byteBuffer.getLong();
        return new UUID(high, low);
    }

    static @NonNull String byteStringToString(@NonNull ByteString bs) {
        return ByteBufUtil.hexDump((byte[])bs.bytesOrEmpty());
    }

    static @Nullable Object convert(@NonNull Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof ByteString) {
            ByteString bs = (ByteString)o;
            return implicit ? ByteStringConversions.implicitConversion(bs, targetType) : ByteStringConversions.explicitConversion(bs, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull ByteString bs, OpcUaDataType targetType) {
        switch (targetType) {
            case Guid: {
                return ByteStringConversions.byteStringToGuid(bs);
            }
            case String: {
                return ByteStringConversions.byteStringToString(bs);
            }
        }
        return ByteStringConversions.implicitConversion(bs, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull ByteString bs, OpcUaDataType targetType) {
        return null;
    }
}

