/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class BooleanConversions {
    private BooleanConversions() {
    }

    static @NonNull UByte booleanToByte(@NonNull Boolean b) {
        return Unsigned.ubyte((int)(b != false ? 1 : 0));
    }

    static @NonNull Double booleanToDouble(@NonNull Boolean b) {
        return b != false ? 1.0 : 0.0;
    }

    static @NonNull Float booleanToFloat(@NonNull Boolean b) {
        return Float.valueOf(b != false ? 1.0f : 0.0f);
    }

    static @NonNull Short booleanToInt16(@NonNull Boolean b) {
        return b != false ? (short)1 : 0;
    }

    static @NonNull Integer booleanToInt32(@NonNull Boolean b) {
        return b != false ? 1 : 0;
    }

    static @NonNull Long booleanToInt64(@NonNull Boolean b) {
        return b != false ? 1L : 0L;
    }

    static @NonNull Byte booleanToSByte(@NonNull Boolean b) {
        return b != false ? (byte)1 : 0;
    }

    static @NonNull String booleanToString(@NonNull Boolean b) {
        return b != false ? "1" : "0";
    }

    static @NonNull UShort booleanToUInt16(@NonNull Boolean b) {
        return b != false ? Unsigned.ushort((int)1) : Unsigned.ushort((int)0);
    }

    static @NonNull UInteger booleanToUInt32(@NonNull Boolean b) {
        return b != false ? Unsigned.uint((int)1) : Unsigned.uint((int)0);
    }

    static @NonNull ULong booleanToUInt64(@NonNull Boolean b) {
        return b != false ? Unsigned.ulong((long)1L) : Unsigned.ulong((long)0L);
    }

    static @Nullable Object convert(@NonNull Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return implicit ? BooleanConversions.implicitConversion(b, targetType) : BooleanConversions.explicitConversion(b, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull Boolean b, OpcUaDataType targetType) {
        switch (targetType) {
            case String: {
                return BooleanConversions.booleanToString(b);
            }
        }
        return BooleanConversions.implicitConversion(b, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull Boolean b, OpcUaDataType targetType) {
        switch (targetType) {
            case Byte: {
                return BooleanConversions.booleanToByte(b);
            }
            case Double: {
                return BooleanConversions.booleanToDouble(b);
            }
            case Float: {
                return BooleanConversions.booleanToFloat(b);
            }
            case Int16: {
                return BooleanConversions.booleanToInt16(b);
            }
            case Int32: {
                return BooleanConversions.booleanToInt32(b);
            }
            case Int64: {
                return BooleanConversions.booleanToInt64(b);
            }
            case SByte: {
                return BooleanConversions.booleanToSByte(b);
            }
            case UInt16: {
                return BooleanConversions.booleanToUInt16(b);
            }
            case UInt32: {
                return BooleanConversions.booleanToUInt32(b);
            }
            case UInt64: {
                return BooleanConversions.booleanToUInt64(b);
            }
        }
        return null;
    }
}

