/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.SecurityConfiguration;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.SessionListener;
import org.eclipse.milo.opcua.sdk.server.identity.Identity;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.servicesets.AbstractServiceSet;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.security.CertificateGroup;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.DigestUtil;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.core.util.SignatureUtil;
import org.eclipse.milo.opcua.stack.core.util.TaskQueue;
import org.eclipse.milo.opcua.stack.transport.server.ServiceRequestContext;
import org.eclipse.milo.shaded.com.google.common.math.DoubleMath;
import org.eclipse.milo.shaded.com.google.common.primitives.Bytes;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<NodeId, Session> createdSessions = new ConcurrentHashMap<NodeId, Session>();
    private final Map<NodeId, Session> activeSessions = new ConcurrentHashMap<NodeId, Session>();
    private final List<SessionListener> sessionListeners = new CopyOnWriteArrayList<SessionListener>();
    private final TaskQueue sessionListenerTaskQueue;
    private final List<ByteString> clientNonces = new CopyOnWriteArrayList<ByteString>();
    private final OpcUaServer server;

    SessionManager(OpcUaServer server, Executor executor) {
        this.server = server;
        this.sessionListenerTaskQueue = new TaskQueue(executor);
    }

    public void killSession(NodeId nodeId, boolean deleteSubscriptions) {
        this.activeSessions.values().stream().filter(s -> s.getSessionId().equals((Object)nodeId)).findFirst().ifPresent(s -> {
            s.close(deleteSubscriptions);
            this.sessionListenerTaskQueue.execute(() -> this.sessionListeners.forEach(l -> l.onSessionClosed((Session)s)));
        });
    }

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    public List<Session> getAllSessions() {
        ArrayList<Session> sessions = new ArrayList<Session>();
        sessions.addAll(this.createdSessions.values());
        sessions.addAll(this.activeSessions.values());
        return sessions;
    }

    public UInteger getCurrentSessionCount() {
        return Unsigned.uint((int)(this.createdSessions.size() + this.activeSessions.size()));
    }

    public Session getSession(ServiceRequestContext context, RequestHeader requestHeader) throws UaException {
        long secureChannelId = context.getSecureChannel().getChannelId();
        NodeId authToken = requestHeader.getAuthenticationToken();
        Session session = this.activeSessions.get(authToken);
        if (session == null) {
            session = this.createdSessions.get(authToken);
            if (session != null) {
                session.close(true);
                throw new UaException(2150039552L);
            }
            throw new UaException(2149908480L);
        }
        if (session.getSecureChannelId() != secureChannelId) {
            session.getSessionDiagnostics().getUnauthorizedRequestCount().increment();
            throw new UaException(0x80220000L);
        }
        session.updateLastActivity();
        return session;
    }

    public CreateSessionResponse createSession(ServiceRequestContext context, CreateSessionRequest request) throws UaException {
        X509Certificate clientCertificateFromRequest;
        long maxSessionCount = this.server.getConfig().getLimits().getMaxSessions().longValue();
        if ((long)(this.createdSessions.size() + this.activeSessions.size()) >= maxSessionCount) {
            throw new UaException(2153119744L);
        }
        ByteString serverNonce = NonceUtil.generateNonce((int)32);
        NodeId authenticationToken = new NodeId(0, NonceUtil.generateNonce((int)32));
        long maxRequestMessageSize = this.server.getConfig().getEncodingLimits().getMaxMessageSize();
        double revisedSessionTimeout = Math.max(5000.0, Math.min(this.server.getConfig().getLimits().getMaxSessionTimeout(), request.getRequestedSessionTimeout()));
        ApplicationDescription clientDescription = request.getClientDescription();
        long secureChannelId = context.getSecureChannel().getChannelId();
        SecurityPolicy securityPolicy = context.getSecureChannel().getSecurityPolicy();
        String transportProfileUri = context.getTransportProfile().getUri();
        EndpointDescription[] serverEndpoints = (EndpointDescription[])this.server.getApplicationContext().getEndpointDescriptions().stream().filter(ed -> {
            String endpointUrl = ed.getEndpointUrl();
            return endpointUrl == null || !endpointUrl.endsWith("/discovery");
        }).filter(ed -> SessionManager.endpointMatchesUrl(ed, request.getEndpointUrl())).filter(ed -> org.eclipse.milo.shaded.com.google.common.base.Objects.equal((Object)transportProfileUri, (Object)ed.getTransportProfileUri())).map(SessionManager::stripNonEssentialFields).toArray(EndpointDescription[]::new);
        if (serverEndpoints.length == 0) {
            serverEndpoints = (EndpointDescription[])this.server.getApplicationContext().getEndpointDescriptions().stream().filter(ed -> {
                String endpointUrl = ed.getEndpointUrl();
                return endpointUrl == null || !endpointUrl.endsWith("/discovery");
            }).filter(ed -> org.eclipse.milo.shaded.com.google.common.base.Objects.equal((Object)transportProfileUri, (Object)ed.getTransportProfileUri())).map(SessionManager::stripNonEssentialFields).toArray(EndpointDescription[]::new);
        }
        ByteString clientNonce = request.getClientNonce();
        if (securityPolicy != SecurityPolicy.None) {
            NonceUtil.validateNonce((ByteString)clientNonce);
            if (this.clientNonces.contains(clientNonce)) {
                throw new UaException(2149842944L);
            }
        }
        if (securityPolicy != SecurityPolicy.None && clientNonce.isNotNull()) {
            this.clientNonces.add(clientNonce);
            while (this.clientNonces.size() > 64) {
                this.clientNonces.remove(0);
            }
        }
        if (securityPolicy != SecurityPolicy.None && !org.eclipse.milo.shaded.com.google.common.base.Objects.equal((Object)(clientCertificateFromRequest = CertificateUtil.decodeCertificate((byte[])request.getClientCertificate().bytesOrEmpty())), (Object)context.getSecureChannel().getRemoteCertificate())) {
            throw new UaException(2148728832L, "certificate used to open secure channel differs from certificate used to create session");
        }
        SecurityConfiguration securityConfiguration = this.createSecurityConfiguration(context.getSecureChannel());
        if (securityPolicy != SecurityPolicy.None) {
            X509Certificate clientCertificate = securityConfiguration.getClientCertificate();
            List<X509Certificate> clientCertificateChain = securityConfiguration.getClientCertificateChain();
            if (clientCertificate == null || clientCertificateChain == null) {
                throw new UaException(2148728832L, "client certificate must be non-null");
            }
            X509Certificate serverCertificate = securityConfiguration.getServerCertificate();
            if (serverCertificate == null) {
                throw new UaException(0x80020000L, "server certificate must be non-null");
            }
            CertificateGroup certificateGroup = (CertificateGroup)this.server.getConfig().getCertificateManager().getCertificateGroup(CertificateUtil.thumbprint((X509Certificate)serverCertificate)).orElseThrow(() -> new UaException(0x80890000L, "no certificate group for server certificate"));
            certificateGroup.getCertificateValidator().validateCertificateChain(clientCertificateChain, clientDescription.getApplicationUri(), null);
        }
        SignatureData serverSignature = this.getServerSignature(securityPolicy, securityConfiguration.getKeyPair(), clientNonce, securityConfiguration.getClientCertificateBytes());
        NodeId sessionId = new NodeId(1, "Session:" + String.valueOf(UUID.randomUUID()));
        String sessionName = request.getSessionName();
        Duration sessionTimeout = Duration.ofMillis(DoubleMath.roundToLong((double)revisedSessionTimeout, (RoundingMode)RoundingMode.UP));
        Session session = new Session(this.server, sessionId, sessionName, sessionTimeout, clientDescription, request.getServerUri(), request.getMaxResponseMessageSize(), this.findSessionEndpoint(context), secureChannelId, securityConfiguration);
        session.setLastNonce(serverNonce);
        session.setClientAddress(context.clientAddress());
        session.addLifecycleListener((s, remove) -> {
            this.createdSessions.remove(authenticationToken);
            this.activeSessions.remove(authenticationToken);
            this.sessionListenerTaskQueue.execute(() -> this.sessionListeners.forEach(l -> l.onSessionClosed(s)));
        });
        this.createdSessions.put(authenticationToken, session);
        this.sessionListenerTaskQueue.execute(() -> this.sessionListeners.forEach(l -> l.onSessionCreated(session)));
        return new CreateSessionResponse(AbstractServiceSet.createResponseHeader((UaRequestMessageType)request), sessionId, authenticationToken, Double.valueOf(revisedSessionTimeout), serverNonce, securityConfiguration.getServerCertificateBytes(), serverEndpoints, new SignedSoftwareCertificate[0], serverSignature, Unsigned.uint((long)maxRequestMessageSize));
    }

    private SecurityConfiguration createSecurityConfiguration(SecureChannel secureChannel) throws UaException {
        SecurityPolicy securityPolicy = secureChannel.getSecurityPolicy();
        MessageSecurityMode securityMode = secureChannel.getMessageSecurityMode();
        X509Certificate clientCertificate = null;
        List clientCertificateChain = null;
        KeyPair keyPair = null;
        X509Certificate serverCertificate = null;
        List serverCertificateChain = null;
        if (securityPolicy != SecurityPolicy.None) {
            clientCertificate = secureChannel.getRemoteCertificate();
            clientCertificateChain = secureChannel.getRemoteCertificateChain();
            ByteString thumbprint = ByteString.of((byte[])DigestUtil.sha1((byte[])secureChannel.getLocalCertificateBytes().bytes()));
            keyPair = (KeyPair)this.server.getConfig().getCertificateManager().getKeyPair(thumbprint).orElseThrow(() -> new UaException(0x80890000L));
            serverCertificate = (X509Certificate)this.server.getConfig().getCertificateManager().getCertificate(thumbprint).orElseThrow(() -> new UaException(0x80890000L));
            serverCertificateChain = this.server.getConfig().getCertificateManager().getCertificateChain(thumbprint).map(List::of).orElseThrow(() -> new UaException(0x80890000L));
        }
        return new SecurityConfiguration(securityPolicy, securityMode, keyPair, serverCertificate, serverCertificateChain, clientCertificate, clientCertificateChain);
    }

    private static boolean endpointMatchesUrl(EndpointDescription endpoint, String requestedEndpointUrl) {
        String endpointHost = EndpointUtil.getHost((String)Objects.requireNonNullElse(endpoint.getEndpointUrl(), ""));
        String requestedHost = EndpointUtil.getHost((String)Objects.requireNonNullElse(requestedEndpointUrl, ""));
        return Objects.requireNonNullElse(endpointHost, "").equalsIgnoreCase(Objects.requireNonNullElse(requestedHost, ""));
    }

    private static EndpointDescription stripNonEssentialFields(EndpointDescription endpoint) {
        ApplicationDescription applicationDescription = endpoint.getServer();
        ApplicationDescription newApplicationDescription = new ApplicationDescription(applicationDescription.getApplicationUri(), null, null, ApplicationType.Server, null, null, null);
        return new EndpointDescription(endpoint.getEndpointUrl(), newApplicationDescription, ByteString.NULL_VALUE, endpoint.getSecurityMode(), endpoint.getSecurityPolicyUri(), endpoint.getUserIdentityTokens(), endpoint.getTransportProfileUri(), endpoint.getSecurityLevel());
    }

    public ActivateSessionResponse activateSession(ServiceRequestContext context, ActivateSessionRequest request) throws UaException {
        long secureChannelId = context.getSecureChannel().getChannelId();
        NodeId authToken = request.getRequestHeader().getAuthenticationToken();
        SignedSoftwareCertificate[] clientSoftwareCertificates = Objects.requireNonNullElse(request.getClientSoftwareCertificates(), new SignedSoftwareCertificate[0]);
        Session session = this.createdSessions.get(authToken);
        if (session == null) {
            session = this.activeSessions.get(authToken);
            if (session == null) {
                throw new UaException(2149908480L);
            }
            SessionManager.verifyClientSignature(session, request);
            SecurityConfiguration securityConfiguration = session.getSecurityConfiguration();
            if (session.getSecureChannelId() == secureChannelId) {
                UserIdentityToken identityToken = this.decodeIdentityToken(request.getUserIdentityToken(), session.getEndpoint().getUserIdentityTokens());
                Identity identity = this.validateIdentityToken(session, identityToken, request.getUserTokenSignature());
                Object[] results = new StatusCode[clientSoftwareCertificates.length];
                Arrays.fill(results, StatusCode.GOOD);
                ByteString serverNonce = NonceUtil.generateNonce((int)32);
                session.setClientAddress(context.clientAddress());
                session.setIdentity(identity, identityToken);
                session.setLastNonce(serverNonce);
                session.setLocaleIds(request.getLocaleIds());
                return new ActivateSessionResponse(AbstractServiceSet.createResponseHeader((UaRequestMessageType)request), serverNonce, (StatusCode[])results, new DiagnosticInfo[0]);
            }
            ByteString clientCertificateBytes = context.getSecureChannel().getRemoteCertificateBytes();
            UserIdentityToken identityToken = this.decodeIdentityToken(request.getUserIdentityToken(), session.getEndpoint().getUserIdentityTokens());
            Identity identity = this.validateIdentityToken(session, identityToken, request.getUserTokenSignature());
            boolean sameIdentity = identity.equalTo(session.getIdentity());
            boolean sameCertificate = org.eclipse.milo.shaded.com.google.common.base.Objects.equal((Object)clientCertificateBytes, (Object)securityConfiguration.getClientCertificateBytes());
            if (sameIdentity && sameCertificate) {
                SecurityConfiguration newSecurityConfiguration = this.createSecurityConfiguration(context.getSecureChannel());
                EndpointDescription endpoint = this.findSessionEndpoint(context);
                session.setEndpoint(endpoint);
                session.setSecureChannelId(secureChannelId);
                session.setSecurityConfiguration(newSecurityConfiguration);
                this.logger.debug("Session id={} is now associated with secureChannelId={}", (Object)session.getSessionId(), (Object)secureChannelId);
                Object[] results = new StatusCode[clientSoftwareCertificates.length];
                Arrays.fill(results, StatusCode.GOOD);
                ByteString serverNonce = NonceUtil.generateNonce((int)32);
                session.setClientAddress(context.clientAddress());
                session.setLastNonce(serverNonce);
                session.setLocaleIds(request.getLocaleIds());
                return new ActivateSessionResponse(AbstractServiceSet.createResponseHeader((UaRequestMessageType)request), serverNonce, (StatusCode[])results, new DiagnosticInfo[0]);
            }
            throw new UaException(2148728832L);
        }
        if (secureChannelId != session.getSecureChannelId()) {
            throw new UaException(2148728832L);
        }
        SessionManager.verifyClientSignature(session, request);
        UserIdentityToken identityToken = this.decodeIdentityToken(request.getUserIdentityToken(), session.getEndpoint().getUserIdentityTokens());
        Identity identity = this.validateIdentityToken(session, identityToken, request.getUserTokenSignature());
        this.createdSessions.remove(authToken);
        this.activeSessions.put(authToken, session);
        Object[] results = new StatusCode[clientSoftwareCertificates.length];
        Arrays.fill(results, StatusCode.GOOD);
        ByteString serverNonce = NonceUtil.generateNonce((int)32);
        session.setClientAddress(context.clientAddress());
        session.setIdentity(identity, identityToken);
        session.setLocaleIds(request.getLocaleIds());
        session.setLastNonce(serverNonce);
        return new ActivateSessionResponse(AbstractServiceSet.createResponseHeader((UaRequestMessageType)request), serverNonce, (StatusCode[])results, new DiagnosticInfo[0]);
    }

    private EndpointDescription findSessionEndpoint(ServiceRequestContext context) throws UaException {
        return this.server.getApplicationContext().getEndpointDescriptions().stream().filter(e -> {
            boolean transportMatch = Objects.equals(e.getTransportProfileUri(), context.getTransportProfile().getUri());
            boolean pathMatch = Objects.equals(EndpointUtil.getPath((String)e.getEndpointUrl()), EndpointUtil.getPath((String)context.getEndpointUrl()));
            boolean securityPolicyMatch = Objects.equals(e.getSecurityPolicyUri(), context.getSecureChannel().getSecurityPolicy().getUri());
            boolean securityModeMatch = Objects.equals(e.getSecurityMode(), context.getSecureChannel().getMessageSecurityMode());
            return transportMatch && pathMatch && securityPolicyMatch && securityModeMatch;
        }).findFirst().orElseThrow(() -> {
            String message = String.format("no matching endpoint found: transportProfile=%s, endpointUrl=%s, securityPolicy=%s, securityMode=%s", context.getTransportProfile(), context.getEndpointUrl(), context.getSecureChannel().getSecurityPolicy(), context.getSecureChannel().getMessageSecurityMode());
            return new UaException(2148728832L, message);
        });
    }

    private static void verifyClientSignature(Session session, ActivateSessionRequest request) throws UaException {
        SecurityConfiguration securityConfiguration = session.getSecurityConfiguration();
        if (securityConfiguration.getSecurityPolicy() != SecurityPolicy.None) {
            SignatureData clientSignature = request.getClientSignature();
            ByteString serverCertificateBs = securityConfiguration.getServerCertificateBytes();
            ByteString lastNonceBs = session.getLastNonce();
            try {
                byte[] dataBytes = Bytes.concat((byte[][])new byte[][]{serverCertificateBs.bytesOrEmpty(), lastNonceBs.bytesOrEmpty()});
                try {
                    SignatureUtil.verify((SecurityAlgorithm)SecurityAlgorithm.fromUri((String)clientSignature.getAlgorithm()), (X509Certificate)securityConfiguration.getClientCertificate(), (byte[])dataBytes, (byte[])clientSignature.getSignature().bytesOrEmpty());
                }
                catch (UaException e) {
                    throw new UaException(0x80580000L, (Throwable)e);
                }
            }
            catch (UaException e) {
                ByteString serverCertificateChainBs = securityConfiguration.getServerCertificateChainBytes();
                if (serverCertificateBs.equals((Object)serverCertificateChainBs)) {
                    throw e;
                }
                byte[] dataBytes = Bytes.concat((byte[][])new byte[][]{serverCertificateChainBs.bytesOrEmpty(), lastNonceBs.bytesOrEmpty()});
                try {
                    SignatureUtil.verify((SecurityAlgorithm)SecurityAlgorithm.fromUri((String)clientSignature.getAlgorithm()), (X509Certificate)securityConfiguration.getClientCertificate(), (byte[])dataBytes, (byte[])clientSignature.getSignature().bytesOrEmpty());
                }
                catch (UaException ex) {
                    throw new UaException(0x80580000L, (Throwable)e);
                }
            }
        }
    }

    private @NonNull UserIdentityToken decodeIdentityToken(@Nullable ExtensionObject identityTokenXo, @Nullable UserTokenPolicy[] tokenPolicies) {
        if (identityTokenXo != null && !identityTokenXo.isNull()) {
            UaStructuredType identityToken;
            try {
                identityToken = identityTokenXo.decode(this.server.getStaticEncodingContext());
            }
            catch (Exception ignored) {
                identityToken = null;
            }
            if (identityToken instanceof UserIdentityToken) {
                return (UserIdentityToken)identityToken;
            }
        }
        String policyId = Stream.of(tokenPolicies).filter(p -> p != null && p.getTokenType() == UserTokenType.Anonymous).findFirst().map(UserTokenPolicy::getPolicyId).orElse(null);
        return new AnonymousIdentityToken(policyId);
    }

    private Identity validateIdentityToken(Session session, Object tokenObject, SignatureData tokenSignature) throws UaException {
        IdentityValidator identityValidator = this.server.getConfig().getIdentityValidator();
        UserTokenPolicy tokenPolicy = this.validatePolicyId(session, tokenObject);
        if (tokenObject instanceof UserIdentityToken) {
            return identityValidator.validateIdentityToken(session, (UserIdentityToken)tokenObject, tokenPolicy, tokenSignature);
        }
        throw new UaException(0x80200000L);
    }

    private UserTokenPolicy validatePolicyId(Session session, Object tokenObject) throws UaException {
        if (tokenObject instanceof UserIdentityToken) {
            UserIdentityToken token = (UserIdentityToken)tokenObject;
            String policyId = token.getPolicyId();
            UserTokenPolicy[] userIdentityTokens = Objects.requireNonNullElse(session.getEndpoint().getUserIdentityTokens(), new UserTokenPolicy[0]);
            Optional<UserTokenPolicy> policy = Stream.of(userIdentityTokens).filter(t -> org.eclipse.milo.shaded.com.google.common.base.Objects.equal((Object)policyId, (Object)t.getPolicyId())).findFirst();
            return policy.orElseThrow(() -> new UaException(0x80200000L, "policy not found: " + policyId));
        }
        throw new UaException(0x80200000L);
    }

    public CloseSessionResponse closeSession(CloseSessionRequest request, ServiceRequestContext context) throws UaException {
        long secureChannelId = context.getSecureChannel().getChannelId();
        NodeId authToken = request.getRequestHeader().getAuthenticationToken();
        Session session = this.activeSessions.get(authToken);
        if (session != null) {
            if (session.getSecureChannelId() != secureChannelId) {
                throw new UaException(0x80220000L);
            }
            this.activeSessions.remove(authToken);
            session.close(request.getDeleteSubscriptions());
            return new CloseSessionResponse(AbstractServiceSet.createResponseHeader((UaRequestMessageType)request));
        }
        session = this.createdSessions.get(authToken);
        if (session == null) {
            throw new UaException(2149908480L);
        }
        if (session.getSecureChannelId() != secureChannelId) {
            throw new UaException(0x80220000L);
        }
        this.createdSessions.remove(authToken);
        session.close(request.getDeleteSubscriptions());
        return new CloseSessionResponse(AbstractServiceSet.createResponseHeader((UaRequestMessageType)request));
    }

    private SignatureData getServerSignature(SecurityPolicy securityPolicy, KeyPair keyPair, ByteString clientNonce, ByteString clientCertificate) throws UaException {
        if (securityPolicy == SecurityPolicy.None) {
            return new SignatureData(null, null);
        }
        try {
            SecurityAlgorithm algorithm = securityPolicy.getAsymmetricSignatureAlgorithm();
            byte[] data = Bytes.concat((byte[][])new byte[][]{clientCertificate.bytes(), clientNonce.bytes()});
            byte[] signature = SignatureUtil.sign((SecurityAlgorithm)algorithm, (PrivateKey)keyPair.getPrivate(), (ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(data)});
            return new SignatureData(algorithm.getUri(), ByteString.of((byte[])signature));
        }
        catch (UaRuntimeException e) {
            throw new UaException(2148728832L);
        }
    }
}

