/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.EnumSet;
import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.NumericRange;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.WriteMask;
import org.eclipse.milo.opcua.sdk.core.nodes.DataTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.AccessContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaServerNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableTypeNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.Matrix;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeWriter.class);

    public static StatusCode writeAttribute(AccessContext context, UaServerNode node, UInteger attributeId, DataValue value, @Nullable String indexRange) {
        Optional aid = AttributeId.from((UInteger)attributeId);
        if (aid.isPresent()) {
            return AttributeWriter.writeAttribute(context, node, (AttributeId)aid.get(), value, indexRange);
        }
        return new StatusCode(2150957056L);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatusCode writeAttribute(AccessContext context, UaServerNode node, AttributeId attributeId, DataValue value, @Nullable String indexRange) {
        if (!AttributeId.getAttributes((NodeClass)node.getNodeClass()).contains(attributeId)) {
            return new StatusCode(2150957056L);
        }
        if (attributeId == AttributeId.UserRolePermissions) {
            return new StatusCode(2151350272L);
        }
        if (attributeId == AttributeId.Value) {
            if (node instanceof UaVariableNode) {
                EnumSet enumSet;
                UaVariableNode variableNode = (UaVariableNode)node;
                AccessLevelExType accessLevelEx = variableNode.getAccessLevelEx();
                if (accessLevelEx != null ? !accessLevelEx.getCurrentWrite() : !(enumSet = AccessLevel.fromValue((UByte)variableNode.getAccessLevel())).contains(AccessLevel.CurrentWrite)) {
                    return new StatusCode(2151350272L);
                }
            } else {
                if (!(node instanceof UaVariableTypeNode)) return new StatusCode(2150957056L);
                UaVariableTypeNode variableTypeNode = (UaVariableTypeNode)node;
                EnumSet writeMasks = WriteMask.fromMask((UInteger)variableTypeNode.getWriteMask());
                if (!writeMasks.contains(WriteMask.ValueForVariableType)) {
                    return new StatusCode(2151350272L);
                }
            }
        } else {
            WriteMask writeMask = WriteMask.forAttribute((AttributeId)attributeId);
            EnumSet writeMasks = WriteMask.fromMask((UInteger)node.getWriteMask());
            if (!writeMasks.contains(writeMask)) {
                return new StatusCode(2151350272L);
            }
        }
        Variant updateVariant = value.value();
        if (indexRange != null && !indexRange.isEmpty()) {
            try {
                void var8_15;
                Object valueAtRange;
                Object object;
                NumericRange range = NumericRange.parse((String)indexRange);
                Object currentValue = node.getAttribute(AccessContext.INTERNAL, attributeId);
                if (currentValue instanceof DataValue) {
                    DataValue dataValue = (DataValue)currentValue;
                    currentValue = dataValue.value().value();
                }
                if (currentValue instanceof Matrix) {
                    Matrix matrix = (Matrix)currentValue;
                    currentValue = matrix.nestedArrayValue();
                }
                if ((object = updateVariant.value()) instanceof Matrix) {
                    Matrix matrix = (Matrix)object;
                    Object object2 = matrix.nestedArrayValue();
                }
                if (ArrayUtil.getValueRank((Object)(valueAtRange = NumericRange.writeToValueAtRange((Object)currentValue, (Object)var8_15, (NumericRange)range))) > 1) {
                    valueAtRange = new Matrix(valueAtRange);
                }
                updateVariant = new Variant(valueAtRange);
            }
            catch (UaException e) {
                return e.getStatusCode();
            }
        }
        DateTime sourceTime = value.sourceTime();
        DateTime serverTime = value.serverTime();
        value = new DataValue(updateVariant, value.statusCode(), sourceTime == null || sourceTime.isNull() ? DateTime.now() : sourceTime, serverTime == null || serverTime.isNull() ? DateTime.now() : serverTime);
        if (attributeId == AttributeId.Value) {
            try {
                UInteger[] arrayDimensions;
                Integer valueRank;
                void var8_20;
                if (node instanceof VariableNode) {
                    NodeId nodeId = ((VariableNode)node).getDataType();
                } else if (node instanceof VariableTypeNode) {
                    NodeId nodeId = ((VariableTypeNode)node).getDataType();
                } else {
                    Object var8_19 = null;
                }
                if (var8_20 != null) {
                    boolean allowNulls = false;
                    if (node instanceof UaVariableNode) {
                        Boolean b = ((UaVariableNode)node).getAllowNulls();
                        allowNulls = b != null ? b : false;
                    }
                    value = AttributeWriter.validateDataType(node.getNodeContext().getServer(), (NodeId)var8_20, value, allowNulls);
                }
                if (node instanceof VariableNode) {
                    valueRank = ((VariableNode)node).getValueRank();
                    arrayDimensions = ((VariableNode)node).getArrayDimensions();
                } else if (node instanceof VariableTypeNode) {
                    valueRank = ((VariableTypeNode)node).getValueRank();
                    arrayDimensions = ((VariableTypeNode)node).getArrayDimensions();
                } else {
                    valueRank = 0;
                    arrayDimensions = null;
                }
                if (valueRank > 0) {
                    AttributeWriter.validateArrayType(valueRank, arrayDimensions, value);
                }
            }
            catch (UaException uaException) {
                return uaException.getStatusCode();
            }
        }
        try {
            node.writeAttribute(context, attributeId, value);
            return StatusCode.GOOD;
        }
        catch (UaException uaException) {
            return uaException.getStatusCode();
        }
    }

    private static DataValue validateDataType(OpcUaServer server, NodeId dataType, DataValue value, boolean allowNulls) throws UaException {
        Class<?> valueClass;
        Class<?> expectedClass;
        Variant variant = value.value();
        Object o = variant.value();
        if (o == null) {
            if (allowNulls) {
                return value;
            }
            throw new UaException(2155085824L);
        }
        if (o instanceof Matrix) {
            Matrix matrix = (Matrix)o;
            o = matrix.nestedArrayValue();
        }
        if ((expectedClass = AttributeWriter.getExpectedClass(server, dataType, valueClass = o.getClass().isArray() ? ArrayUtil.getType((Object)o) : o.getClass())) != null) {
            LOGGER.debug("dataTypeId={}, valueClass={}, expectedClass={}", new Object[]{dataType, valueClass.getSimpleName(), expectedClass.getSimpleName()});
            if (!expectedClass.isAssignableFrom(valueClass)) {
                if (o instanceof ByteString) {
                    ByteString byteString = (ByteString)o;
                    if (expectedClass == UByte.class) {
                        return new DataValue(new Variant((Object)byteString.uBytes()), value.statusCode(), value.sourceTime(), value.serverTime());
                    }
                }
                if (expectedClass == Variant.class) {
                    return value;
                }
                throw new UaException(2155085824L);
            }
        } else {
            throw new UaException(2155085824L);
        }
        return value;
    }

    private static void validateArrayType(Integer valueRank, UInteger[] arrayDimensions, DataValue value) throws UaException {
        Variant variant = value.value();
        Object o = variant.value();
        if (o == null) {
            return;
        }
        if (o instanceof Matrix) {
            Matrix matrix = (Matrix)o;
            o = matrix.nestedArrayValue();
        }
        boolean valueIsArray = o.getClass().isArray();
        switch (valueRank) {
            case -3: {
                int[] valueDimensions;
                if (!valueIsArray || (valueDimensions = ArrayUtil.getDimensions((Object)o)).length <= 1) break;
                throw new UaException(2155085824L);
            }
            case -2: {
                break;
            }
            case -1: {
                if (!valueIsArray) break;
                throw new UaException(2155085824L);
            }
            case 0: {
                if (valueIsArray) break;
                throw new UaException(2155085824L);
            }
            default: {
                if (!valueIsArray) {
                    throw new UaException(2155085824L);
                }
                int[] valueDimensions = ArrayUtil.getDimensions((Object)o);
                if (valueDimensions.length != valueRank) {
                    throw new UaException(2155085824L);
                }
                int[] nodeDimensions = Optional.ofNullable(arrayDimensions).map(uia -> {
                    int[] dims = new int[((UInteger[])uia).length];
                    for (int i = 0; i < ((UInteger[])uia).length; ++i) {
                        dims[i] = uia[i].intValue();
                    }
                    return dims;
                }).orElse(new int[0]);
                if (nodeDimensions.length <= 0) break;
                if (nodeDimensions.length != valueDimensions.length) {
                    throw new UaException(2155085824L);
                }
                for (int i = 0; i < nodeDimensions.length; ++i) {
                    if (nodeDimensions[i] <= 0 || valueDimensions[i] <= nodeDimensions[i]) continue;
                    throw new UaException(2155085824L);
                }
            }
        }
    }

    private static Class<?> getExpectedClass(OpcUaServer server, NodeId dataTypeId, Class<?> valueClass) throws UaException {
        if (OpcUaDataType.isBuiltin((NodeId)dataTypeId)) {
            return OpcUaDataType.getBackingClass((NodeId)dataTypeId);
        }
        if (AttributeWriter.subtypeOf(server, dataTypeId, NodeIds.Structure)) {
            return ExtensionObject.class;
        }
        if (AttributeWriter.subtypeOf(server, dataTypeId, NodeIds.Enumeration)) {
            return Integer.class;
        }
        NodeId superBuiltInType = AttributeWriter.findConcreteBuiltInSuperTypeId(server, dataTypeId);
        if (superBuiltInType != null) {
            return OpcUaDataType.getBackingClass((NodeId)superBuiltInType);
        }
        int valueDataTypeId = OpcUaDataType.getBuiltinTypeId(valueClass);
        if (valueDataTypeId > -1) {
            NodeId builtInTypeId = new NodeId(0, valueDataTypeId);
            if (dataTypeId.equals((Object)builtInTypeId) || AttributeWriter.subtypeOf(server, builtInTypeId, dataTypeId)) {
                return valueClass;
            }
            throw new UaException(2155085824L);
        }
        throw new UaException(2155085824L);
    }

    private static boolean subtypeOf(OpcUaServer server, NodeId dataTypeId, NodeId potentialSuperTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            NodeId superTypeId = AttributeWriter.getSuperTypeId(server, dataTypeId);
            if (superTypeId != null) {
                return superTypeId.equals((Object)potentialSuperTypeId) || AttributeWriter.subtypeOf(server, superTypeId, potentialSuperTypeId);
            }
            return false;
        }
        return false;
    }

    private static @Nullable NodeId findConcreteBuiltInSuperTypeId(OpcUaServer server, NodeId dataTypeId) {
        if (OpcUaDataType.isBuiltin((NodeId)dataTypeId) && AttributeWriter.isConcrete(server, dataTypeId)) {
            return dataTypeId;
        }
        NodeId superTypeId = AttributeWriter.getSuperTypeId(server, dataTypeId);
        if (superTypeId != null) {
            return AttributeWriter.findConcreteBuiltInSuperTypeId(server, superTypeId);
        }
        return null;
    }

    private static @Nullable NodeId getSuperTypeId(OpcUaServer server, NodeId dataTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            return dataTypeNode.getReferences().stream().filter(Reference.SUBTYPE_OF).flatMap(r -> r.getTargetNodeId().toNodeId(server.getNamespaceTable()).stream()).findFirst().orElse(null);
        }
        return null;
    }

    private static boolean isAbstract(OpcUaServer server, NodeId dataTypeId) {
        UaNode node = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (node instanceof DataTypeNode) {
            return ((DataTypeNode)node).getIsAbstract();
        }
        return false;
    }

    private static boolean isConcrete(OpcUaServer server, NodeId dataTypeId) {
        return !AttributeWriter.isAbstract(server, dataTypeId);
    }
}

