/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.typetree;

import java.util.List;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.typetree.VariableType;
import org.eclipse.milo.opcua.sdk.core.typetree.VariableTypeTree;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableTypeNode;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.ReferenceTypes;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.util.Tree;

public class VariableTypeTreeBuilder {
    public static VariableTypeTree build(OpcUaServer server) {
        UaNode rootNode = server.getAddressSpaceManager().getManagedNode(NodeIds.BaseVariableType).orElseThrow();
        Tree tree = new Tree(null, (Object)new ServerVariableType((UaVariableTypeNode)rootNode));
        VariableTypeTreeBuilder.addChildren((Tree<VariableType>)tree, server);
        return new VariableTypeTree(tree);
    }

    private static void addChildren(Tree<VariableType> tree, OpcUaServer server) {
        NodeId nodeId = ((VariableType)tree.getValue()).getNodeId();
        List<Reference> references = server.getAddressSpaceManager().getManagedReferences(nodeId, r -> r.isForward() && r.getReferenceTypeId().equals((Object)ReferenceTypes.HasSubtype));
        List childNodes = references.stream().flatMap(r -> server.getAddressSpaceManager().getManagedNode(r.getTargetNodeId()).stream()).toList();
        for (UaNode childNode : childNodes) {
            UaVariableTypeNode variableTypeNode = (UaVariableTypeNode)childNode;
            tree.addChild((Object)new ServerVariableType(variableTypeNode));
        }
        for (Tree child : tree.getChildren()) {
            VariableTypeTreeBuilder.addChildren((Tree<VariableType>)child, server);
        }
    }

    private static class ServerVariableType
    implements VariableType {
        private final UaVariableTypeNode node;

        public ServerVariableType(UaVariableTypeNode node) {
            this.node = node;
        }

        public QualifiedName getBrowseName() {
            return this.node.getBrowseName();
        }

        public NodeId getNodeId() {
            return this.node.getNodeId();
        }

        public DataValue getValue() {
            return this.node.getValue();
        }

        public NodeId getDataType() {
            return this.node.getDataType();
        }

        public Integer getValueRank() {
            return this.node.getValueRank();
        }

        public UInteger[] getArrayDimensions() {
            return this.node.getArrayDimensions();
        }

        public Boolean isAbstract() {
            return this.node.getIsAbstract();
        }
    }
}

