/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.servicesets.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.server.AddressSpace;
import org.eclipse.milo.opcua.sdk.server.ContinuationPoint;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.servicesets.AbstractServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.ViewServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.helpers.BrowseHelper;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.helpers.BrowsePathsHelper;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.eclipse.milo.opcua.stack.transport.server.ServiceRequestContext;

public class DefaultViewServiceSet
implements ViewServiceSet {
    private final OpcUaServer server;

    public DefaultViewServiceSet(OpcUaServer server) {
        this.server = server;
    }

    @Override
    public BrowseResponse onBrowse(ServiceRequestContext context, BrowseRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            BrowseResponse browseResponse = this.browse(request, session).get();
            return browseResponse;
        }
        catch (Exception e) {
            session.getSessionDiagnostics().getBrowseCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw new UaException((Throwable)e);
        }
        finally {
            session.getSessionDiagnostics().getBrowseCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public BrowseNextResponse onBrowseNext(ServiceRequestContext context, BrowseNextRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            BrowseNextResponse browseNextResponse = this.browseNext(request, session);
            return browseNextResponse;
        }
        catch (Exception e) {
            session.getSessionDiagnostics().getBrowseNextCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw new UaException((Throwable)e);
        }
        finally {
            session.getSessionDiagnostics().getBrowseNextCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public TranslateBrowsePathsToNodeIdsResponse onTranslateBrowsePaths(ServiceRequestContext context, TranslateBrowsePathsToNodeIdsRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            BrowsePathsHelper browsePathsHelper = new BrowsePathsHelper(() -> Optional.ofNullable(session), this.server);
            TranslateBrowsePathsToNodeIdsResponse translateBrowsePathsToNodeIdsResponse = browsePathsHelper.translateBrowsePaths(request);
            return translateBrowsePathsToNodeIdsResponse;
        }
        catch (Exception e) {
            session.getSessionDiagnostics().getTranslateBrowsePathsToNodeIdsCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw new UaException((Throwable)e);
        }
        finally {
            session.getSessionDiagnostics().getTranslateBrowsePathsToNodeIdsCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public RegisterNodesResponse onRegisterNodes(ServiceRequestContext context, RegisterNodesRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            RegisterNodesResponse registerNodesResponse = this.registerNodes(request, session);
            return registerNodesResponse;
        }
        catch (Exception e) {
            session.getSessionDiagnostics().getRegisterNodesCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw new UaException((Throwable)e);
        }
        finally {
            session.getSessionDiagnostics().getRegisterNodesCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public UnregisterNodesResponse onUnregisterNodes(ServiceRequestContext context, UnregisterNodesRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            UnregisterNodesResponse unregisterNodesResponse = this.unregisterNodes(request, session);
            return unregisterNodesResponse;
        }
        catch (Exception e) {
            session.getSessionDiagnostics().getUnregisterNodesCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw new UaException((Throwable)e);
        }
        finally {
            session.getSessionDiagnostics().getUnregisterNodesCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    private CompletableFuture<BrowseResponse> browse(BrowseRequest request, Session session) {
        List nodesToBrowse = Lists.ofNullable((Object[])request.getNodesToBrowse());
        if (nodesToBrowse.isEmpty()) {
            return FutureUtils.failedUaFuture((long)0x800F0000L);
        }
        if (nodesToBrowse.size() > this.server.getConfig().getLimits().getMaxNodesPerBrowse().intValue()) {
            return FutureUtils.failedUaFuture((long)0x80100000L);
        }
        if (request.getView().getViewId().isNotNull() && !this.server.getRegisteredViews().contains(request.getView().getViewId())) {
            return FutureUtils.failedUaFuture((long)2154496000L);
        }
        List<BrowseResult> results = BrowseHelper.browse(this.server, () -> Optional.of(session), request);
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        BrowseResponse response = new BrowseResponse(header, (BrowseResult[])results.toArray(BrowseResult[]::new), new DiagnosticInfo[0]);
        return CompletableFuture.completedFuture(response);
    }

    private BrowseNextResponse browseNext(BrowseNextRequest request, Session session) throws UaException {
        List continuationPoints = Lists.ofNullable((Object[])request.getContinuationPoints());
        if (continuationPoints.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if (continuationPoints.size() > this.server.getConfig().getLimits().getMaxBrowseContinuationPoints().intValue()) {
            throw new UaException(0x80100000L);
        }
        ArrayList<BrowseResult> results = new ArrayList<BrowseResult>();
        for (ByteString bs : continuationPoints) {
            if (request.getReleaseContinuationPoints().booleanValue()) {
                results.add(DefaultViewServiceSet.release(session, bs));
                continue;
            }
            results.add(DefaultViewServiceSet.references(session, bs));
        }
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new BrowseNextResponse(header, (BrowseResult[])results.toArray(BrowseResult[]::new), new DiagnosticInfo[0]);
    }

    private static BrowseResult release(Session session, ByteString bs) {
        ContinuationPoint c = session.getBrowseContinuationPoints().remove(bs);
        return c != null ? new BrowseResult(StatusCode.GOOD, null, null) : new BrowseResult(new StatusCode(2152333312L), null, null);
    }

    private static BrowseResult references(Session session, ByteString bs) {
        ContinuationPoint c = session.getBrowseContinuationPoints().remove(bs);
        if (c != null) {
            int max = c.max();
            List<ReferenceDescription> references = c.references();
            if (references.size() > max) {
                List<ReferenceDescription> subList = references.subList(0, max);
                List<ReferenceDescription> current = List.copyOf(subList);
                subList.clear();
                session.getBrowseContinuationPoints().put(c.id(), c);
                return new BrowseResult(StatusCode.GOOD, c.id(), current.toArray(new ReferenceDescription[0]));
            }
            return new BrowseResult(StatusCode.GOOD, null, references.toArray(new ReferenceDescription[0]));
        }
        return new BrowseResult(new StatusCode(2152333312L), null, null);
    }

    private RegisterNodesResponse registerNodes(RegisterNodesRequest request, Session session) throws UaException {
        List nodeIds = Lists.ofNullable((Object[])request.getNodesToRegister());
        if (nodeIds.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if (nodeIds.size() > this.server.getConfig().getLimits().getMaxNodesPerRegisterNodes().intValue()) {
            throw new UaException(0x80100000L);
        }
        AddressSpace.RegisterNodesContext registerNodesContext = new AddressSpace.RegisterNodesContext(this.server, session);
        List<NodeId> registeredNodeIds = this.server.getAddressSpaceManager().registerNodes(registerNodesContext, nodeIds);
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new RegisterNodesResponse(header, registeredNodeIds.toArray(new NodeId[0]));
    }

    private UnregisterNodesResponse unregisterNodes(UnregisterNodesRequest request, Session session) throws UaException {
        List nodeIds = Lists.ofNullable((Object[])request.getNodesToUnregister());
        if (nodeIds.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if (nodeIds.size() > this.server.getConfig().getLimits().getMaxNodesPerRegisterNodes().intValue()) {
            throw new UaException(0x80100000L);
        }
        AddressSpace.UnregisterNodesContext unregisterNodesContext = new AddressSpace.UnregisterNodesContext(this.server, session);
        this.server.getAddressSpaceManager().unregisterNodes(unregisterNodesContext, nodeIds);
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new UnregisterNodesResponse(header);
    }
}

