/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.servicesets.impl;

import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.SessionManager;
import org.eclipse.milo.opcua.sdk.server.diagnostics.ServerDiagnosticsSummary;
import org.eclipse.milo.opcua.sdk.server.servicesets.AbstractServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.SessionServiceSet;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CancelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CancelResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionResponse;
import org.eclipse.milo.opcua.stack.transport.server.ServiceRequestContext;

public class DefaultSessionServiceSet
implements SessionServiceSet {
    private final OpcUaServer server;

    public DefaultSessionServiceSet(OpcUaServer server) {
        this.server = server;
    }

    @Override
    public CreateSessionResponse onCreateSession(ServiceRequestContext context, CreateSessionRequest request) throws UaException {
        ServerDiagnosticsSummary serverDiagnosticsSummary = this.server.getDiagnosticsSummary();
        SessionManager sessionManager = this.server.getSessionManager();
        try {
            CreateSessionResponse response = sessionManager.createSession(context, request);
            serverDiagnosticsSummary.getCumulatedSessionCount().increment();
            return response;
        }
        catch (UaException e) {
            serverDiagnosticsSummary.getRejectedSessionCount().increment();
            if (e.getStatusCode().isSecurityError()) {
                serverDiagnosticsSummary.getSecurityRejectedSessionCount().increment();
            }
            throw e;
        }
    }

    @Override
    public ActivateSessionResponse onActivateSession(ServiceRequestContext context, ActivateSessionRequest request) throws UaException {
        SessionManager sessionManager = this.server.getSessionManager();
        try {
            return sessionManager.activateSession(context, request);
        }
        catch (UaException e) {
            ServerDiagnosticsSummary serverDiagnosticsSummary = this.server.getDiagnosticsSummary();
            serverDiagnosticsSummary.getRejectedSessionCount().increment();
            if (e.getStatusCode().isSecurityError()) {
                serverDiagnosticsSummary.getSecurityRejectedSessionCount().increment();
            }
            throw e;
        }
    }

    @Override
    public CloseSessionResponse onCloseSession(ServiceRequestContext context, CloseSessionRequest request) throws UaException {
        SessionManager sessionManager = this.server.getSessionManager();
        return sessionManager.closeSession(request, context);
    }

    @Override
    public CancelResponse onCancel(ServiceRequestContext context, CancelRequest request) {
        return new CancelResponse(AbstractServiceSet.createResponseHeader((UaRequestMessageType)request), UInteger.MIN);
    }
}

