/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.servicesets.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.milo.opcua.sdk.core.util.GroupMapCollate;
import org.eclipse.milo.opcua.sdk.server.AddressSpace;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.servicesets.AbstractServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.MethodServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.AccessController;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.eclipse.milo.opcua.stack.core.types.structured.CallRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.eclipse.milo.opcua.stack.transport.server.ServiceRequestContext;

public class DefaultMethodServiceSet
implements MethodServiceSet {
    private final OpcUaServer server;

    public DefaultMethodServiceSet(OpcUaServer server) {
        this.server = server;
    }

    @Override
    public CallResponse onCall(ServiceRequestContext context, CallRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            CallResponse callResponse = this.call(request, session);
            return callResponse;
        }
        catch (UaException e) {
            session.getSessionDiagnostics().getCallCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw e;
        }
        finally {
            session.getSessionDiagnostics().getCallCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    private CallResponse call(CallRequest request, Session session) throws UaException {
        List methodsToCall = Lists.ofNullable((Object[])request.getMethodsToCall());
        if (methodsToCall.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if ((long)methodsToCall.size() > this.server.getConfig().getLimits().getMaxNodesPerMethodCall().longValue()) {
            throw new UaException(0x80100000L);
        }
        Map<CallMethodRequest, AccessController.AccessResult> accessResults = this.server.getAccessController().checkCallAccess(session, methodsToCall);
        List results = GroupMapCollate.groupMapCollate((List)methodsToCall, accessResults::get, accessResult -> group -> {
            if (accessResult instanceof AccessController.AccessResult.Denied) {
                AccessController.AccessResult.Denied denied = (AccessController.AccessResult.Denied)accessResult;
                CallMethodResult result = new CallMethodResult(denied.statusCode(), null, null, null);
                return Collections.nCopies(group.size(), result);
            }
            DiagnosticsContext<CallMethodRequest> diagnosticsContext = new DiagnosticsContext<CallMethodRequest>();
            AddressSpace.CallContext callContext = new AddressSpace.CallContext(this.server, session, diagnosticsContext, request.getRequestHeader().getAuditEntryId(), request.getRequestHeader().getTimeoutHint(), request.getRequestHeader().getAdditionalHeader());
            return this.server.getAddressSpaceManager().call(callContext, methodsToCall);
        });
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new CallResponse(header, (CallMethodResult[])results.toArray(CallMethodResult[]::new), new DiagnosticInfo[0]);
    }
}

