/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import org.eclipse.milo.opcua.sdk.core.nodes.ViewNode;
import org.eclipse.milo.opcua.sdk.core.nodes.ViewNodeProperties;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.jspecify.annotations.Nullable;

public class UaViewNode
extends UaNode
implements ViewNode {
    private Boolean containsNoLoops;
    private UByte eventNotifier;

    public UaViewNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean containsNoLoops, UByte eventNotifier) {
        super(context, nodeId, NodeClass.View, browseName, displayName, description, writeMask, userWriteMask);
        this.containsNoLoops = containsNoLoops;
        this.eventNotifier = eventNotifier;
    }

    public UaViewNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, Boolean containsNoLoops, UByte eventNotifier) {
        super(context, nodeId, NodeClass.View, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
        this.containsNoLoops = containsNoLoops;
        this.eventNotifier = eventNotifier;
    }

    public Boolean getContainsNoLoops() {
        return (Boolean)this.filterChain.getAttribute(this, AttributeId.ContainsNoLoops);
    }

    public UByte getEventNotifier() {
        return (UByte)this.filterChain.getAttribute(this, AttributeId.EventNotifier);
    }

    public void setContainsNoLoops(Boolean containsNoLoops) {
        this.filterChain.setAttribute(this, AttributeId.ContainsNoLoops, containsNoLoops);
    }

    public void setEventNotifier(UByte eventNotifier) {
        this.filterChain.setAttribute(this, AttributeId.EventNotifier, eventNotifier);
    }

    @Override
    public synchronized Object getAttribute(AttributeId attributeId) {
        return switch (attributeId) {
            case AttributeId.ContainsNoLoops -> this.containsNoLoops;
            case AttributeId.EventNotifier -> this.eventNotifier;
            default -> super.getAttribute(attributeId);
        };
    }

    @Override
    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        switch (attributeId) {
            case ContainsNoLoops: {
                this.containsNoLoops = (Boolean)value;
                break;
            }
            case EventNotifier: {
                this.eventNotifier = (UByte)value;
                break;
            }
            default: {
                super.setAttribute(attributeId, value);
                return;
            }
        }
        this.fireAttributeChanged(attributeId, value);
    }

    public @Nullable String getNodeVersion() {
        return this.getProperty(ViewNodeProperties.NodeVersion).orElse(null);
    }

    public @Nullable UInteger getViewVersion() {
        return this.getProperty(ViewNodeProperties.ViewVersion).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(ViewNodeProperties.NodeVersion, nodeVersion);
    }

    public void setViewVersion(UInteger viewVersion) {
        this.setProperty(ViewNodeProperties.ViewVersion, viewVersion);
    }
}

