/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.namespaces;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.server.AddressSpaceComposite;
import org.eclipse.milo.opcua.sdk.server.AddressSpaceFilter;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.LifecycleManager;
import org.eclipse.milo.opcua.sdk.server.ManagedAddressSpaceFragmentWithLifecycle;
import org.eclipse.milo.opcua.sdk.server.Namespace;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.SimpleAddressSpaceFilter;
import org.eclipse.milo.opcua.sdk.server.diagnostics.objects.ServerDiagnosticsObject;
import org.eclipse.milo.opcua.sdk.server.items.DataItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

public class ServerNamespace
extends AddressSpaceComposite
implements Lifecycle,
Namespace {
    private final LifecycleManager lifecycleManager = new LifecycleManager();
    private final String namespaceUri;
    private final UShort namespaceIndex;

    public ServerNamespace(final OpcUaServer server) {
        super(server);
        this.namespaceUri = server.getConfig().getApplicationUri();
        this.namespaceIndex = (UShort)server.getNamespaceTable().add(this.namespaceUri);
        this.lifecycleManager.addLifecycle(new Lifecycle(){

            @Override
            public void startup() {
                server.getAddressSpaceManager().register(ServerNamespace.this);
            }

            @Override
            public void shutdown() {
                server.getAddressSpaceManager().unregister(ServerNamespace.this);
            }
        });
        DiagnosticsFragment diagnosticsFragment = new DiagnosticsFragment(server);
        this.lifecycleManager.addLifecycle(diagnosticsFragment);
    }

    @Override
    public final void startup() {
        this.lifecycleManager.startup();
    }

    @Override
    public final void shutdown() {
        this.lifecycleManager.shutdown();
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public UShort getNamespaceIndex() {
        return this.namespaceIndex;
    }

    private class DiagnosticsFragment
    extends ManagedAddressSpaceFragmentWithLifecycle {
        private final AddressSpaceFilter filter;
        private final SubscriptionModel subscriptionModel;

        public DiagnosticsFragment(OpcUaServer server) {
            super(server, ServerNamespace.this);
            this.filter = SimpleAddressSpaceFilter.create(this.getNodeManager()::containsNode);
            this.subscriptionModel = new SubscriptionModel(server, this);
            ServerDiagnosticsTypeNode serverDiagnosticsNode = (ServerDiagnosticsTypeNode)this.getServer().getAddressSpaceManager().getManagedNode(NodeIds.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + String.valueOf(NodeIds.Server_ServerDiagnostics)));
            serverDiagnosticsNode.getEnabledFlagNode().setUserAccessLevel(AccessLevel.toValue((Set)AccessLevel.READ_WRITE));
            ServerDiagnosticsObject serverDiagnosticsObject = new ServerDiagnosticsObject(serverDiagnosticsNode, this.getNodeManager());
            this.getLifecycleManager().addLifecycle(this.subscriptionModel);
            this.getLifecycleManager().addLifecycle(serverDiagnosticsObject);
        }

        @Override
        public AddressSpaceFilter getFilter() {
            return this.filter;
        }

        @Override
        public void onDataItemsCreated(List<DataItem> dataItems) {
            this.subscriptionModel.onDataItemsCreated(dataItems);
        }

        @Override
        public void onDataItemsModified(List<DataItem> dataItems) {
            this.subscriptionModel.onDataItemsModified(dataItems);
        }

        @Override
        public void onDataItemsDeleted(List<DataItem> dataItems) {
            this.subscriptionModel.onDataItemsDeleted(dataItems);
        }

        @Override
        public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
            this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
        }
    }
}

