/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.SubscribedDataSetType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.ConfigurationVersionDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.FieldTargetDataType;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface TargetVariablesType
extends SubscribedDataSetType {
    public static final QualifiedProperty<FieldTargetDataType[]> TARGET_VARIABLES = new QualifiedProperty("http://opcfoundation.org/UA/", "TargetVariables", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14744"), Integer.valueOf(1), FieldTargetDataType[].class);

    public FieldTargetDataType[] getTargetVariables();

    public void setTargetVariables(FieldTargetDataType[] var1);

    public PropertyType getTargetVariablesNode();

    public MethodNode getAddTargetVariablesMethodNode();

    public MethodNode getRemoveTargetVariablesMethodNode();

    public static abstract class RemoveTargetVariablesMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public RemoveTargetVariablesMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ConfigurationVersion", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14593").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("TargetsToRemove", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("RemoveResults", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=19").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ConfigurationVersionDataType configurationVersion = (ConfigurationVersionDataType)inputValues[0].getValue();
            UInteger[] targetsToRemove = (UInteger[])inputValues[1].getValue();
            Out<StatusCode[]> removeResults = new Out<StatusCode[]>();
            this.invoke(context, configurationVersion, targetsToRemove, removeResults);
            return new Variant[]{new Variant((Object)removeResults.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ConfigurationVersionDataType var2, UInteger[] var3, Out<StatusCode[]> var4) throws UaException;
    }

    public static abstract class AddTargetVariablesMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddTargetVariablesMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ConfigurationVersion", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14593").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("TargetVariablesToAdd", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14744").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("AddResults", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=19").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ConfigurationVersionDataType configurationVersion = (ConfigurationVersionDataType)inputValues[0].getValue();
            FieldTargetDataType[] targetVariablesToAdd = (FieldTargetDataType[])inputValues[1].getValue();
            Out<StatusCode[]> addResults = new Out<StatusCode[]>();
            this.invoke(context, configurationVersion, targetVariablesToAdd, addResults);
            return new Variant[]{new Variant((Object)addResults.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ConfigurationVersionDataType var2, FieldTargetDataType[] var3, Out<StatusCode[]> var4) throws UaException;
    }
}

