/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectType;
import org.eclipse.milo.opcua.sdk.server.model.objects.NamespacesType;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerCapabilitiesType;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerDiagnosticsType;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerRedundancyType;
import org.eclipse.milo.opcua.sdk.server.model.objects.VendorServerInfoType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.model.variables.ServerStatusType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerStatusDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.TimeZoneDataType;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface ServerType
extends BaseObjectType {
    public static final QualifiedProperty<String[]> SERVER_ARRAY = new QualifiedProperty("http://opcfoundation.org/UA/", "ServerArray", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(1), String[].class);
    public static final QualifiedProperty<String[]> NAMESPACE_ARRAY = new QualifiedProperty("http://opcfoundation.org/UA/", "NamespaceArray", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(1), String[].class);
    public static final QualifiedProperty<UInteger> URIS_VERSION = new QualifiedProperty("http://opcfoundation.org/UA/", "UrisVersion", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=20998"), Integer.valueOf(-1), UInteger.class);
    public static final QualifiedProperty<UByte> SERVICE_LEVEL = new QualifiedProperty("http://opcfoundation.org/UA/", "ServiceLevel", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=3"), Integer.valueOf(-1), UByte.class);
    public static final QualifiedProperty<Boolean> AUDITING = new QualifiedProperty("http://opcfoundation.org/UA/", "Auditing", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);
    public static final QualifiedProperty<DateTime> ESTIMATED_RETURN_TIME = new QualifiedProperty("http://opcfoundation.org/UA/", "EstimatedReturnTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=13"), Integer.valueOf(-1), DateTime.class);
    public static final QualifiedProperty<TimeZoneDataType> LOCAL_TIME = new QualifiedProperty("http://opcfoundation.org/UA/", "LocalTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=8912"), Integer.valueOf(-1), TimeZoneDataType.class);

    public String[] getServerArray();

    public void setServerArray(String[] var1);

    public PropertyType getServerArrayNode();

    public String[] getNamespaceArray();

    public void setNamespaceArray(String[] var1);

    public PropertyType getNamespaceArrayNode();

    public UInteger getUrisVersion();

    public void setUrisVersion(UInteger var1);

    public PropertyType getUrisVersionNode();

    public UByte getServiceLevel();

    public void setServiceLevel(UByte var1);

    public PropertyType getServiceLevelNode();

    public Boolean getAuditing();

    public void setAuditing(Boolean var1);

    public PropertyType getAuditingNode();

    public DateTime getEstimatedReturnTime();

    public void setEstimatedReturnTime(DateTime var1);

    public PropertyType getEstimatedReturnTimeNode();

    public TimeZoneDataType getLocalTime();

    public void setLocalTime(TimeZoneDataType var1);

    public PropertyType getLocalTimeNode();

    public ServerStatusType getServerStatusNode();

    public ServerStatusDataType getServerStatus();

    public void setServerStatus(ServerStatusDataType var1);

    public ServerCapabilitiesType getServerCapabilitiesNode();

    public ServerDiagnosticsType getServerDiagnosticsNode();

    public VendorServerInfoType getVendorServerInfoNode();

    public ServerRedundancyType getServerRedundancyNode();

    public NamespacesType getNamespacesNode();

    public MethodNode getGetMonitoredItemsMethodNode();

    public MethodNode getResendDataMethodNode();

    public MethodNode getSetSubscriptionDurableMethodNode();

    public MethodNode getRequestServerStateChangeMethodNode();

    public static abstract class RequestServerStateChangeMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RequestServerStateChangeMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("State", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=852").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("EstimatedReturnTime", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=13").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("SecondsTillShutdown", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Reason", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=21").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Restart", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ServerState state = (ServerState)inputValues[0].getValue();
            DateTime estimatedReturnTime = (DateTime)inputValues[1].getValue();
            UInteger secondsTillShutdown = (UInteger)inputValues[2].getValue();
            LocalizedText reason = (LocalizedText)inputValues[3].getValue();
            Boolean restart = (Boolean)inputValues[4].getValue();
            this.invoke(context, state, estimatedReturnTime, secondsTillShutdown, reason, restart);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ServerState var2, DateTime var3, UInteger var4, LocalizedText var5, Boolean var6) throws UaException;
    }

    public static abstract class SetSubscriptionDurableMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public SetSubscriptionDurableMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SubscriptionId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("LifetimeInHours", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("RevisedLifetimeInHours", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger subscriptionId = (UInteger)inputValues[0].getValue();
            UInteger lifetimeInHours = (UInteger)inputValues[1].getValue();
            Out<UInteger> revisedLifetimeInHours = new Out<UInteger>();
            this.invoke(context, subscriptionId, lifetimeInHours, revisedLifetimeInHours);
            return new Variant[]{new Variant((Object)revisedLifetimeInHours.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2, UInteger var3, Out<UInteger> var4) throws UaException;
    }

    public static abstract class ResendDataMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public ResendDataMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SubscriptionId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger subscriptionId = (UInteger)inputValues[0].getValue();
            this.invoke(context, subscriptionId);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2) throws UaException;
    }

    public static abstract class GetMonitoredItemsMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public GetMonitoredItemsMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SubscriptionId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ServerHandles", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("ClientHandles", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger subscriptionId = (UInteger)inputValues[0].getValue();
            Out<UInteger[]> serverHandles = new Out<UInteger[]>();
            Out<UInteger[]> clientHandles = new Out<UInteger[]>();
            this.invoke(context, subscriptionId, serverHandles, clientHandles);
            return new Variant[]{new Variant((Object)serverHandles.get()), new Variant((Object)clientHandles.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2, Out<UInteger[]> var3, Out<UInteger[]> var4) throws UaException;
    }
}

