/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointType;
import org.eclipse.milo.opcua.stack.core.types.structured.IdentityMappingRuleType;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface RoleType
extends BaseObjectType {
    public static final QualifiedProperty<IdentityMappingRuleType[]> IDENTITIES = new QualifiedProperty("http://opcfoundation.org/UA/", "Identities", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15634"), Integer.valueOf(1), IdentityMappingRuleType[].class);
    public static final QualifiedProperty<Boolean> APPLICATIONS_EXCLUDE = new QualifiedProperty("http://opcfoundation.org/UA/", "ApplicationsExclude", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);
    public static final QualifiedProperty<String[]> APPLICATIONS = new QualifiedProperty("http://opcfoundation.org/UA/", "Applications", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(1), String[].class);
    public static final QualifiedProperty<Boolean> ENDPOINTS_EXCLUDE = new QualifiedProperty("http://opcfoundation.org/UA/", "EndpointsExclude", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);
    public static final QualifiedProperty<EndpointType[]> ENDPOINTS = new QualifiedProperty("http://opcfoundation.org/UA/", "Endpoints", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15528"), Integer.valueOf(1), EndpointType[].class);
    public static final QualifiedProperty<Boolean> CUSTOM_CONFIGURATION = new QualifiedProperty("http://opcfoundation.org/UA/", "CustomConfiguration", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);

    public IdentityMappingRuleType[] getIdentities();

    public void setIdentities(IdentityMappingRuleType[] var1);

    public PropertyType getIdentitiesNode();

    public Boolean getApplicationsExclude();

    public void setApplicationsExclude(Boolean var1);

    public PropertyType getApplicationsExcludeNode();

    public String[] getApplications();

    public void setApplications(String[] var1);

    public PropertyType getApplicationsNode();

    public Boolean getEndpointsExclude();

    public void setEndpointsExclude(Boolean var1);

    public PropertyType getEndpointsExcludeNode();

    public EndpointType[] getEndpoints();

    public void setEndpoints(EndpointType[] var1);

    public PropertyType getEndpointsNode();

    public Boolean getCustomConfiguration();

    public void setCustomConfiguration(Boolean var1);

    public PropertyType getCustomConfigurationNode();

    public MethodNode getAddIdentityMethodNode();

    public MethodNode getRemoveIdentityMethodNode();

    public MethodNode getAddApplicationMethodNode();

    public MethodNode getRemoveApplicationMethodNode();

    public MethodNode getAddEndpointMethodNode();

    public MethodNode getRemoveEndpointMethodNode();

    public static abstract class RemoveEndpointMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RemoveEndpointMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Endpoint", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15528").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            EndpointType endpoint = (EndpointType)inputValues[0].getValue();
            this.invoke(context, endpoint);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, EndpointType var2) throws UaException;
    }

    public static abstract class AddEndpointMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public AddEndpointMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Endpoint", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15528").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            EndpointType endpoint = (EndpointType)inputValues[0].getValue();
            this.invoke(context, endpoint);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, EndpointType var2) throws UaException;
    }

    public static abstract class RemoveApplicationMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RemoveApplicationMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ApplicationUri", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String applicationUri = (String)inputValues[0].getValue();
            this.invoke(context, applicationUri);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2) throws UaException;
    }

    public static abstract class AddApplicationMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public AddApplicationMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ApplicationUri", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String applicationUri = (String)inputValues[0].getValue();
            this.invoke(context, applicationUri);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2) throws UaException;
    }

    public static abstract class RemoveIdentityMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RemoveIdentityMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Rule", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15634").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            IdentityMappingRuleType rule = (IdentityMappingRuleType)inputValues[0].getValue();
            this.invoke(context, rule);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, IdentityMappingRuleType var2) throws UaException;
    }

    public static abstract class AddIdentityMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public AddIdentityMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Rule", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15634").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            IdentityMappingRuleType rule = (IdentityMappingRuleType)inputValues[0].getValue();
            this.invoke(context, rule);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, IdentityMappingRuleType var2) throws UaException;
    }
}

