/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.PublishedDataSetType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.ConfigurationVersionDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishedVariableDataType;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface PublishedDataItemsType
extends PublishedDataSetType {
    public static final QualifiedProperty<PublishedVariableDataType[]> PUBLISHED_DATA = new QualifiedProperty("http://opcfoundation.org/UA/", "PublishedData", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14273"), Integer.valueOf(1), PublishedVariableDataType[].class);

    public PublishedVariableDataType[] getPublishedData();

    public void setPublishedData(PublishedVariableDataType[] var1);

    public PropertyType getPublishedDataNode();

    public MethodNode getAddVariablesMethodNode();

    public MethodNode getRemoveVariablesMethodNode();

    public static abstract class RemoveVariablesMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public RemoveVariablesMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ConfigurationVersion", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14593").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("VariablesToRemove", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("NewConfigurationVersion", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14593").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("RemoveResults", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=19").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ConfigurationVersionDataType configurationVersion = (ConfigurationVersionDataType)inputValues[0].getValue();
            UInteger[] variablesToRemove = (UInteger[])inputValues[1].getValue();
            Out<ConfigurationVersionDataType> newConfigurationVersion = new Out<ConfigurationVersionDataType>();
            Out<StatusCode[]> removeResults = new Out<StatusCode[]>();
            this.invoke(context, configurationVersion, variablesToRemove, newConfigurationVersion, removeResults);
            return new Variant[]{new Variant((Object)newConfigurationVersion.get()), new Variant((Object)removeResults.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ConfigurationVersionDataType var2, UInteger[] var3, Out<ConfigurationVersionDataType> var4, Out<StatusCode[]> var5) throws UaException;
    }

    public static abstract class AddVariablesMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddVariablesMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ConfigurationVersion", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14593").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("FieldNameAliases", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("PromotedFields", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("VariablesToAdd", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14273").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("NewConfigurationVersion", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14593").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("AddResults", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=19").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ConfigurationVersionDataType configurationVersion = (ConfigurationVersionDataType)inputValues[0].getValue();
            String[] fieldNameAliases = (String[])inputValues[1].getValue();
            Boolean[] promotedFields = (Boolean[])inputValues[2].getValue();
            PublishedVariableDataType[] variablesToAdd = (PublishedVariableDataType[])inputValues[3].getValue();
            Out<ConfigurationVersionDataType> newConfigurationVersion = new Out<ConfigurationVersionDataType>();
            Out<StatusCode[]> addResults = new Out<StatusCode[]>();
            this.invoke(context, configurationVersion, fieldNameAliases, promotedFields, variablesToAdd, newConfigurationVersion, addResults);
            return new Variant[]{new Variant((Object)newConfigurationVersion.get()), new Variant((Object)addResults.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ConfigurationVersionDataType var2, String[] var3, Boolean[] var4, PublishedVariableDataType[] var5, Out<ConfigurationVersionDataType> var6, Out<StatusCode[]> var7) throws UaException;
    }
}

