/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface PubSubKeyPushTargetType
extends BaseObjectType {
    public static final QualifiedProperty<String> APPLICATION_URI = new QualifiedProperty("http://opcfoundation.org/UA/", "ApplicationUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<String> ENDPOINT_URL = new QualifiedProperty("http://opcfoundation.org/UA/", "EndpointUrl", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<String> SECURITY_POLICY_URI = new QualifiedProperty("http://opcfoundation.org/UA/", "SecurityPolicyUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<UserTokenPolicy> USER_TOKEN_TYPE = new QualifiedProperty("http://opcfoundation.org/UA/", "UserTokenType", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=304"), Integer.valueOf(-1), UserTokenPolicy.class);
    public static final QualifiedProperty<UShort> REQUESTED_KEY_COUNT = new QualifiedProperty("http://opcfoundation.org/UA/", "RequestedKeyCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=5"), Integer.valueOf(-1), UShort.class);
    public static final QualifiedProperty<Double> RETRY_INTERVAL = new QualifiedProperty("http://opcfoundation.org/UA/", "RetryInterval", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=290"), Integer.valueOf(-1), Double.class);
    public static final QualifiedProperty<DateTime> LAST_PUSH_EXECUTION_TIME = new QualifiedProperty("http://opcfoundation.org/UA/", "LastPushExecutionTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=13"), Integer.valueOf(-1), DateTime.class);
    public static final QualifiedProperty<DateTime> LAST_PUSH_ERROR_TIME = new QualifiedProperty("http://opcfoundation.org/UA/", "LastPushErrorTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=13"), Integer.valueOf(-1), DateTime.class);

    public String getApplicationUri();

    public void setApplicationUri(String var1);

    public PropertyType getApplicationUriNode();

    public String getEndpointUrl();

    public void setEndpointUrl(String var1);

    public PropertyType getEndpointUrlNode();

    public String getSecurityPolicyUri();

    public void setSecurityPolicyUri(String var1);

    public PropertyType getSecurityPolicyUriNode();

    public UserTokenPolicy getUserTokenType();

    public void setUserTokenType(UserTokenPolicy var1);

    public PropertyType getUserTokenTypeNode();

    public UShort getRequestedKeyCount();

    public void setRequestedKeyCount(UShort var1);

    public PropertyType getRequestedKeyCountNode();

    public Double getRetryInterval();

    public void setRetryInterval(Double var1);

    public PropertyType getRetryIntervalNode();

    public DateTime getLastPushExecutionTime();

    public void setLastPushExecutionTime(DateTime var1);

    public PropertyType getLastPushExecutionTimeNode();

    public DateTime getLastPushErrorTime();

    public void setLastPushErrorTime(DateTime var1);

    public PropertyType getLastPushErrorTimeNode();

    public MethodNode getConnectSecurityGroupsMethodNode();

    public MethodNode getDisconnectSecurityGroupsMethodNode();

    public MethodNode getTriggerKeyUpdateMethodNode();

    public static abstract class TriggerKeyUpdateMethod
    extends AbstractMethodInvocationHandler {
        public TriggerKeyUpdateMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return new Argument[0];
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            this.invoke(context);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1) throws UaException;
    }

    public static abstract class DisconnectSecurityGroupsMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public DisconnectSecurityGroupsMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SecurityGroupIds", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("DisconnectResults", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=19").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            NodeId[] securityGroupIds = (NodeId[])inputValues[0].getValue();
            Out<StatusCode[]> disconnectResults = new Out<StatusCode[]>();
            this.invoke(context, securityGroupIds, disconnectResults);
            return new Variant[]{new Variant((Object)disconnectResults.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, NodeId[] var2, Out<StatusCode[]> var3) throws UaException;
    }

    public static abstract class ConnectSecurityGroupsMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public ConnectSecurityGroupsMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SecurityGroupIds", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ConnectResults", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=19").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            NodeId[] securityGroupIds = (NodeId[])inputValues[0].getValue();
            Out<StatusCode[]> connectResults = new Out<StatusCode[]>();
            this.invoke(context, securityGroupIds, connectResults);
            return new Variant[]{new Variant((Object)connectResults.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, NodeId[] var2, Out<StatusCode[]> var3) throws UaException;
    }
}

