/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.FileType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.PubSubConfigurationRefDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.PubSubConfigurationValueDataType;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface PubSubConfigurationType
extends FileType {
    public MethodNode getReserveIdsMethodNode();

    public MethodNode getCloseAndUpdateMethodNode();

    public static abstract class CloseAndUpdateMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public CloseAndUpdateMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("RequireCompleteUpdate", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("ConfigurationReferences", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=25519").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ChangesApplied", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("ReferencesResults", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=19").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("ConfigurationValues", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=25520").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("ConfigurationObjects", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger fileHandle = (UInteger)inputValues[0].getValue();
            Boolean requireCompleteUpdate = (Boolean)inputValues[1].getValue();
            PubSubConfigurationRefDataType[] configurationReferences = (PubSubConfigurationRefDataType[])inputValues[2].getValue();
            Out<Boolean> changesApplied = new Out<Boolean>();
            Out<StatusCode[]> referencesResults = new Out<StatusCode[]>();
            Out<PubSubConfigurationValueDataType[]> configurationValues = new Out<PubSubConfigurationValueDataType[]>();
            Out<NodeId[]> configurationObjects = new Out<NodeId[]>();
            this.invoke(context, fileHandle, requireCompleteUpdate, configurationReferences, changesApplied, referencesResults, configurationValues, configurationObjects);
            return new Variant[]{new Variant((Object)changesApplied.get()), new Variant((Object)referencesResults.get()), new Variant((Object)configurationValues.get()), new Variant((Object)configurationObjects.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2, Boolean var3, PubSubConfigurationRefDataType[] var4, Out<Boolean> var5, Out<StatusCode[]> var6, Out<PubSubConfigurationValueDataType[]> var7, Out<NodeId[]> var8) throws UaException;
    }

    public static abstract class ReserveIdsMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public ReserveIdsMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("TransportProfileUri", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("NumReqWriterGroupIds", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=5").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("NumReqDataSetWriterIds", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=5").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("DefaultPublisherId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=24").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("WriterGroupIds", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=5").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("DataSetWriterIds", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=5").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String transportProfileUri = (String)inputValues[0].getValue();
            UShort numReqWriterGroupIds = (UShort)inputValues[1].getValue();
            UShort numReqDataSetWriterIds = (UShort)inputValues[2].getValue();
            Out<Object> defaultPublisherId = new Out<Object>();
            Out<UShort[]> writerGroupIds = new Out<UShort[]>();
            Out<UShort[]> dataSetWriterIds = new Out<UShort[]>();
            this.invoke(context, transportProfileUri, numReqWriterGroupIds, numReqDataSetWriterIds, defaultPublisherId, writerGroupIds, dataSetWriterIds);
            return new Variant[]{new Variant(defaultPublisherId.get()), new Variant((Object)writerGroupIds.get()), new Variant((Object)dataSetWriterIds.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, UShort var3, UShort var4, Out<Object> var5, Out<UShort[]> var6, Out<UShort[]> var7) throws UaException;
    }
}

