/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.KeyCredentialConfigurationType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class KeyCredentialConfigurationTypeNode
extends BaseObjectTypeNode
implements KeyCredentialConfigurationType {
    public KeyCredentialConfigurationTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    public KeyCredentialConfigurationTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
    }

    @Override
    public PropertyTypeNode getResourceUriNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(KeyCredentialConfigurationType.RESOURCE_URI);
        return propertyNode.orElse(null);
    }

    @Override
    public String getResourceUri() {
        return this.getProperty(KeyCredentialConfigurationType.RESOURCE_URI).orElse(null);
    }

    @Override
    public void setResourceUri(String value) {
        this.setProperty(KeyCredentialConfigurationType.RESOURCE_URI, value);
    }

    @Override
    public PropertyTypeNode getProfileUriNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(KeyCredentialConfigurationType.PROFILE_URI);
        return propertyNode.orElse(null);
    }

    @Override
    public String getProfileUri() {
        return this.getProperty(KeyCredentialConfigurationType.PROFILE_URI).orElse(null);
    }

    @Override
    public void setProfileUri(String value) {
        this.setProperty(KeyCredentialConfigurationType.PROFILE_URI, value);
    }

    @Override
    public PropertyTypeNode getEndpointUrlsNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(KeyCredentialConfigurationType.ENDPOINT_URLS);
        return propertyNode.orElse(null);
    }

    @Override
    public String[] getEndpointUrls() {
        return this.getProperty(KeyCredentialConfigurationType.ENDPOINT_URLS).orElse(null);
    }

    @Override
    public void setEndpointUrls(String[] value) {
        this.setProperty(KeyCredentialConfigurationType.ENDPOINT_URLS, value);
    }

    @Override
    public PropertyTypeNode getCredentialIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(KeyCredentialConfigurationType.CREDENTIAL_ID);
        return propertyNode.orElse(null);
    }

    @Override
    public String getCredentialId() {
        return this.getProperty(KeyCredentialConfigurationType.CREDENTIAL_ID).orElse(null);
    }

    @Override
    public void setCredentialId(String value) {
        this.setProperty(KeyCredentialConfigurationType.CREDENTIAL_ID, value);
    }

    @Override
    public PropertyTypeNode getServiceStatusNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(KeyCredentialConfigurationType.SERVICE_STATUS);
        return propertyNode.orElse(null);
    }

    @Override
    public StatusCode getServiceStatus() {
        return this.getProperty(KeyCredentialConfigurationType.SERVICE_STATUS).orElse(null);
    }

    @Override
    public void setServiceStatus(StatusCode value) {
        this.setProperty(KeyCredentialConfigurationType.SERVICE_STATUS, value);
    }

    @Override
    public UaMethodNode getGetEncryptingKeyMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "GetEncryptingKey", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getUpdateCredentialMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "UpdateCredential", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getDeleteCredentialMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "DeleteCredential", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }
}

