/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface KeyCredentialConfigurationType
extends BaseObjectType {
    public static final QualifiedProperty<String> RESOURCE_URI = new QualifiedProperty("http://opcfoundation.org/UA/", "ResourceUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<String> PROFILE_URI = new QualifiedProperty("http://opcfoundation.org/UA/", "ProfileUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<String[]> ENDPOINT_URLS = new QualifiedProperty("http://opcfoundation.org/UA/", "EndpointUrls", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(1), String[].class);
    public static final QualifiedProperty<String> CREDENTIAL_ID = new QualifiedProperty("http://opcfoundation.org/UA/", "CredentialId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<StatusCode> SERVICE_STATUS = new QualifiedProperty("http://opcfoundation.org/UA/", "ServiceStatus", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=19"), Integer.valueOf(-1), StatusCode.class);

    public String getResourceUri();

    public void setResourceUri(String var1);

    public PropertyType getResourceUriNode();

    public String getProfileUri();

    public void setProfileUri(String var1);

    public PropertyType getProfileUriNode();

    public String[] getEndpointUrls();

    public void setEndpointUrls(String[] var1);

    public PropertyType getEndpointUrlsNode();

    public String getCredentialId();

    public void setCredentialId(String var1);

    public PropertyType getCredentialIdNode();

    public StatusCode getServiceStatus();

    public void setServiceStatus(StatusCode var1);

    public PropertyType getServiceStatusNode();

    public MethodNode getGetEncryptingKeyMethodNode();

    public MethodNode getUpdateCredentialMethodNode();

    public MethodNode getDeleteCredentialMethodNode();

    public static abstract class DeleteCredentialMethod
    extends AbstractMethodInvocationHandler {
        public DeleteCredentialMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return new Argument[0];
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            this.invoke(context);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1) throws UaException;
    }

    public static abstract class UpdateCredentialMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public UpdateCredentialMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("CredentialId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("CredentialSecret", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("CertificateThumbprint", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("SecurityPolicyUri", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String credentialId = (String)inputValues[0].getValue();
            ByteString credentialSecret = (ByteString)inputValues[1].getValue();
            String certificateThumbprint = (String)inputValues[2].getValue();
            String securityPolicyUri = (String)inputValues[3].getValue();
            this.invoke(context, credentialId, credentialSecret, certificateThumbprint, securityPolicyUri);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, ByteString var3, String var4, String var5) throws UaException;
    }

    public static abstract class GetEncryptingKeyMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public GetEncryptingKeyMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("CredentialId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("RequestedSecurityPolicyUri", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("PublicKey", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("RevisedSecurityPolicyUri", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String credentialId = (String)inputValues[0].getValue();
            String requestedSecurityPolicyUri = (String)inputValues[1].getValue();
            Out<ByteString> publicKey = new Out<ByteString>();
            Out<String> revisedSecurityPolicyUri = new Out<String>();
            this.invoke(context, credentialId, requestedSecurityPolicyUri, publicKey, revisedSecurityPolicyUri);
            return new Variant[]{new Variant((Object)publicKey.get()), new Variant((Object)revisedSecurityPolicyUri.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, String var3, Out<ByteString> var4, Out<String> var5) throws UaException;
    }
}

