/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface FileType
extends BaseObjectType {
    public static final QualifiedProperty<ULong> SIZE = new QualifiedProperty("http://opcfoundation.org/UA/", "Size", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=9"), Integer.valueOf(-1), ULong.class);
    public static final QualifiedProperty<Boolean> WRITABLE = new QualifiedProperty("http://opcfoundation.org/UA/", "Writable", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);
    public static final QualifiedProperty<Boolean> USER_WRITABLE = new QualifiedProperty("http://opcfoundation.org/UA/", "UserWritable", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);
    public static final QualifiedProperty<UShort> OPEN_COUNT = new QualifiedProperty("http://opcfoundation.org/UA/", "OpenCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=5"), Integer.valueOf(-1), UShort.class);
    public static final QualifiedProperty<String> MIME_TYPE = new QualifiedProperty("http://opcfoundation.org/UA/", "MimeType", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<UInteger> MAX_BYTE_STRING_LENGTH = new QualifiedProperty("http://opcfoundation.org/UA/", "MaxByteStringLength", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7"), Integer.valueOf(-1), UInteger.class);
    public static final QualifiedProperty<DateTime> LAST_MODIFIED_TIME = new QualifiedProperty("http://opcfoundation.org/UA/", "LastModifiedTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=13"), Integer.valueOf(-1), DateTime.class);

    public ULong getSize();

    public void setSize(ULong var1);

    public PropertyType getSizeNode();

    public Boolean getWritable();

    public void setWritable(Boolean var1);

    public PropertyType getWritableNode();

    public Boolean getUserWritable();

    public void setUserWritable(Boolean var1);

    public PropertyType getUserWritableNode();

    public UShort getOpenCount();

    public void setOpenCount(UShort var1);

    public PropertyType getOpenCountNode();

    public String getMimeType();

    public void setMimeType(String var1);

    public PropertyType getMimeTypeNode();

    public UInteger getMaxByteStringLength();

    public void setMaxByteStringLength(UInteger var1);

    public PropertyType getMaxByteStringLengthNode();

    public DateTime getLastModifiedTime();

    public void setLastModifiedTime(DateTime var1);

    public PropertyType getLastModifiedTimeNode();

    public MethodNode getOpenMethodNode();

    public MethodNode getCloseMethodNode();

    public MethodNode getReadMethodNode();

    public MethodNode getWriteMethodNode();

    public MethodNode getGetPositionMethodNode();

    public MethodNode getSetPositionMethodNode();

    public static abstract class SetPositionMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public SetPositionMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Position", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=9").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger fileHandle = (UInteger)inputValues[0].getValue();
            ULong position = (ULong)inputValues[1].getValue();
            this.invoke(context, fileHandle, position);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2, ULong var3) throws UaException;
    }

    public static abstract class GetPositionMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public GetPositionMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Position", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=9").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger fileHandle = (UInteger)inputValues[0].getValue();
            Out<ULong> position = new Out<ULong>();
            this.invoke(context, fileHandle, position);
            return new Variant[]{new Variant((Object)position.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2, Out<ULong> var3) throws UaException;
    }

    public static abstract class WriteMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public WriteMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Data", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger fileHandle = (UInteger)inputValues[0].getValue();
            ByteString data = (ByteString)inputValues[1].getValue();
            this.invoke(context, fileHandle, data);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2, ByteString var3) throws UaException;
    }

    public static abstract class ReadMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public ReadMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Length", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=6").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Data", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger fileHandle = (UInteger)inputValues[0].getValue();
            Integer length = (Integer)inputValues[1].getValue();
            Out<ByteString> data = new Out<ByteString>();
            this.invoke(context, fileHandle, length, data);
            return new Variant[]{new Variant((Object)data.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2, Integer var3, Out<ByteString> var4) throws UaException;
    }

    public static abstract class CloseMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public CloseMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger fileHandle = (UInteger)inputValues[0].getValue();
            this.invoke(context, fileHandle);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2) throws UaException;
    }

    public static abstract class OpenMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public OpenMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Mode", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=3").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UByte mode = (UByte)inputValues[0].getValue();
            Out<UInteger> fileHandle = new Out<UInteger>();
            this.invoke(context, mode, fileHandle);
            return new Variant[]{new Variant((Object)fileHandle.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UByte var2, Out<UInteger> var3) throws UaException;
    }
}

