/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectType;
import org.eclipse.milo.opcua.sdk.server.model.objects.DataSetReaderMessageType;
import org.eclipse.milo.opcua.sdk.server.model.objects.DataSetReaderTransportType;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubDiagnosticsDataSetReaderType;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubStatusType;
import org.eclipse.milo.opcua.sdk.server.model.objects.SubscribedDataSetType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.ConfigurationVersionDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.DataSetFieldContentMask;
import org.eclipse.milo.opcua.stack.core.types.structured.DataSetMetaDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.FieldTargetDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.KeyValuePair;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface DataSetReaderType
extends BaseObjectType {
    public static final QualifiedProperty<Object> PUBLISHER_ID = new QualifiedProperty("http://opcfoundation.org/UA/", "PublisherId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=24"), Integer.valueOf(-1), Object.class);
    public static final QualifiedProperty<UShort> WRITER_GROUP_ID = new QualifiedProperty("http://opcfoundation.org/UA/", "WriterGroupId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=5"), Integer.valueOf(-1), UShort.class);
    public static final QualifiedProperty<UShort> DATA_SET_WRITER_ID = new QualifiedProperty("http://opcfoundation.org/UA/", "DataSetWriterId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=5"), Integer.valueOf(-1), UShort.class);
    public static final QualifiedProperty<DataSetMetaDataType> DATA_SET_META_DATA = new QualifiedProperty("http://opcfoundation.org/UA/", "DataSetMetaData", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14523"), Integer.valueOf(-1), DataSetMetaDataType.class);
    public static final QualifiedProperty<DataSetFieldContentMask> DATA_SET_FIELD_CONTENT_MASK = new QualifiedProperty("http://opcfoundation.org/UA/", "DataSetFieldContentMask", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15583"), Integer.valueOf(-1), DataSetFieldContentMask.class);
    public static final QualifiedProperty<Double> MESSAGE_RECEIVE_TIMEOUT = new QualifiedProperty("http://opcfoundation.org/UA/", "MessageReceiveTimeout", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=290"), Integer.valueOf(-1), Double.class);
    public static final QualifiedProperty<UInteger> KEY_FRAME_COUNT = new QualifiedProperty("http://opcfoundation.org/UA/", "KeyFrameCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7"), Integer.valueOf(-1), UInteger.class);
    public static final QualifiedProperty<String> HEADER_LAYOUT_URI = new QualifiedProperty("http://opcfoundation.org/UA/", "HeaderLayoutUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<MessageSecurityMode> SECURITY_MODE = new QualifiedProperty("http://opcfoundation.org/UA/", "SecurityMode", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=302"), Integer.valueOf(-1), MessageSecurityMode.class);
    public static final QualifiedProperty<String> SECURITY_GROUP_ID = new QualifiedProperty("http://opcfoundation.org/UA/", "SecurityGroupId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<EndpointDescription[]> SECURITY_KEY_SERVICES = new QualifiedProperty("http://opcfoundation.org/UA/", "SecurityKeyServices", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=312"), Integer.valueOf(1), EndpointDescription[].class);
    public static final QualifiedProperty<KeyValuePair[]> DATA_SET_READER_PROPERTIES = new QualifiedProperty("http://opcfoundation.org/UA/", "DataSetReaderProperties", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14533"), Integer.valueOf(1), KeyValuePair[].class);

    public Object getPublisherId();

    public void setPublisherId(Object var1);

    public PropertyType getPublisherIdNode();

    public UShort getWriterGroupId();

    public void setWriterGroupId(UShort var1);

    public PropertyType getWriterGroupIdNode();

    public UShort getDataSetWriterId();

    public void setDataSetWriterId(UShort var1);

    public PropertyType getDataSetWriterIdNode();

    public DataSetMetaDataType getDataSetMetaData();

    public void setDataSetMetaData(DataSetMetaDataType var1);

    public PropertyType getDataSetMetaDataNode();

    public DataSetFieldContentMask getDataSetFieldContentMask();

    public void setDataSetFieldContentMask(DataSetFieldContentMask var1);

    public PropertyType getDataSetFieldContentMaskNode();

    public Double getMessageReceiveTimeout();

    public void setMessageReceiveTimeout(Double var1);

    public PropertyType getMessageReceiveTimeoutNode();

    public UInteger getKeyFrameCount();

    public void setKeyFrameCount(UInteger var1);

    public PropertyType getKeyFrameCountNode();

    public String getHeaderLayoutUri();

    public void setHeaderLayoutUri(String var1);

    public PropertyType getHeaderLayoutUriNode();

    public MessageSecurityMode getSecurityMode();

    public void setSecurityMode(MessageSecurityMode var1);

    public PropertyType getSecurityModeNode();

    public String getSecurityGroupId();

    public void setSecurityGroupId(String var1);

    public PropertyType getSecurityGroupIdNode();

    public EndpointDescription[] getSecurityKeyServices();

    public void setSecurityKeyServices(EndpointDescription[] var1);

    public PropertyType getSecurityKeyServicesNode();

    public KeyValuePair[] getDataSetReaderProperties();

    public void setDataSetReaderProperties(KeyValuePair[] var1);

    public PropertyType getDataSetReaderPropertiesNode();

    public DataSetReaderTransportType getTransportSettingsNode();

    public DataSetReaderMessageType getMessageSettingsNode();

    public PubSubStatusType getStatusNode();

    public PubSubDiagnosticsDataSetReaderType getDiagnosticsNode();

    public SubscribedDataSetType getSubscribedDataSetNode();

    public MethodNode getCreateTargetVariablesMethodNode();

    public MethodNode getCreateDataSetMirrorMethodNode();

    public static abstract class CreateDataSetMirrorMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public CreateDataSetMirrorMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ParentNodeName", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("RolePermissions", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=96").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ParentNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String parentNodeName = (String)inputValues[0].getValue();
            RolePermissionType[] rolePermissions = (RolePermissionType[])inputValues[1].getValue();
            Out<NodeId> parentNodeId = new Out<NodeId>();
            this.invoke(context, parentNodeName, rolePermissions, parentNodeId);
            return new Variant[]{new Variant((Object)parentNodeId.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, RolePermissionType[] var3, Out<NodeId> var4) throws UaException;
    }

    public static abstract class CreateTargetVariablesMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public CreateTargetVariablesMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ConfigurationVersion", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14593").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("TargetVariablesToAdd", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14744").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("AddResults", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=19").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ConfigurationVersionDataType configurationVersion = (ConfigurationVersionDataType)inputValues[0].getValue();
            FieldTargetDataType[] targetVariablesToAdd = (FieldTargetDataType[])inputValues[1].getValue();
            Out<StatusCode[]> addResults = new Out<StatusCode[]>();
            this.invoke(context, configurationVersion, targetVariablesToAdd, addResults);
            return new Variant[]{new Variant((Object)addResults.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ConfigurationVersionDataType var2, FieldTargetDataType[] var3, Out<StatusCode[]> var4) throws UaException;
    }
}

