/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.items;

import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.items.BaseMonitoredItem;
import org.eclipse.milo.opcua.sdk.server.items.DataItem;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.util.DataChangeMonitoringFilter;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DataChangeTrigger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DeadbandType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.DataChangeFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemNotification;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class MonitoredDataItem
extends BaseMonitoredItem<DataValue>
implements DataItem {
    public static final DataChangeFilter DEFAULT_FILTER = new DataChangeFilter(DataChangeTrigger.StatusValue, Unsigned.uint((int)DeadbandType.None.getValue()), Double.valueOf(0.0));
    private volatile DataValue lastValue = null;
    private volatile DataChangeFilter filter = null;
    private volatile @Nullable Range euRange = null;

    public MonitoredDataItem(OpcUaServer server, Session session, UInteger id, UInteger subscriptionId, ReadValueId readValueId, MonitoringMode monitoringMode, TimestampsToReturn timestamps, UInteger clientHandle, double samplingInterval, UInteger queueSize, boolean discardOldest) {
        super(server, session, id, subscriptionId, readValueId, monitoringMode, timestamps, clientHandle, samplingInterval, queueSize, discardOldest);
    }

    protected DataValue getLastValue() {
        return this.lastValue;
    }

    protected void setLastValue(DataValue lastValue) {
        this.lastValue = lastValue;
    }

    protected DataChangeFilter getFilter() {
        return this.filter;
    }

    protected void setFilter(DataChangeFilter filter) {
        this.filter = filter;
    }

    public @Nullable Range getEuRange() {
        return this.euRange;
    }

    public void setEuRange(@Nullable Range euRange) {
        this.euRange = euRange;
    }

    @Override
    public synchronized void setValue(DataValue value) {
        boolean valuePassesFilter = DataChangeMonitoringFilter.filter(this.lastValue, value, this.filter, this.euRange);
        if (valuePassesFilter) {
            this.lastValue = value;
            this.enqueue(value);
            if (this.triggeredItems != null) {
                this.triggeredItems.values().forEach(item -> {
                    item.triggered = true;
                });
            }
        }
    }

    @Override
    protected synchronized void enqueue(@NonNull DataValue value) {
        if (this.queue.size() < this.queue.maxSize()) {
            this.queue.add(value);
        } else {
            StatusCode statusCode = value.statusCode();
            if (this.getQueueSize() > 1) {
                value = value.withStatus(statusCode.withOverflow());
                Subscription subscription = this.session.getSubscriptionManager().getSubscription(this.subscriptionId);
                if (subscription != null) {
                    subscription.getSubscriptionDiagnostics().getMonitoringQueueOverflowCount().increment();
                }
            } else if (statusCode.isOverflowSet()) {
                value = value.withStatus(statusCode.withoutOverflow());
            }
            if (this.discardOldest) {
                this.queue.add(value);
            } else {
                this.queue.set(this.queue.maxSize() - 1, value);
            }
        }
    }

    @Override
    public synchronized void setQuality(StatusCode quality) {
        if (this.lastValue == null) {
            this.setValue(new DataValue(Variant.NULL_VALUE, quality, DateTime.now(), DateTime.now()));
        } else {
            DataValue value = new DataValue(this.lastValue.value(), quality, DateTime.now(), DateTime.now());
            this.setValue(value);
        }
    }

    @Override
    public boolean isSamplingEnabled() {
        return this.getMonitoringMode() != MonitoringMode.Disabled;
    }

    @Override
    public synchronized void setMonitoringMode(MonitoringMode monitoringMode) {
        if (monitoringMode == MonitoringMode.Disabled) {
            this.lastValue = null;
        }
        super.setMonitoringMode(monitoringMode);
    }

    public synchronized void maybeSendLastValue() {
        if (this.queue.isEmpty() && this.lastValue != null) {
            this.enqueue(this.lastValue);
        }
    }

    @Override
    public void installFilter(MonitoringFilter filter) throws UaException {
        DataChangeFilter dataChangeFilter;
        if (filter instanceof DataChangeFilter) {
            dataChangeFilter = (DataChangeFilter)filter;
            DeadbandType deadbandType = DeadbandType.from((int)dataChangeFilter.getDeadbandType().intValue());
            if (deadbandType == DeadbandType.Percent) {
                Double deadbandPercent = dataChangeFilter.getDeadbandValue();
                if (deadbandPercent < 0.0 || deadbandPercent > 100.0) {
                    throw new UaException(0x808E0000L);
                }
                if (this.euRange == null) {
                    throw new UaException(0x80440000L, "Percent Deadband requires AnalogItemType with valid EURange property");
                }
            }
        } else {
            throw new UaException(0x80440000L);
        }
        this.filter = dataChangeFilter;
    }

    @Override
    public ExtensionObject getFilterResult() {
        return null;
    }

    protected MonitoredItemNotification wrapQueueValue(DataValue value) {
        boolean includeSource = this.timestamps == TimestampsToReturn.Source || this.timestamps == TimestampsToReturn.Both;
        boolean includeServer = this.timestamps == TimestampsToReturn.Server || this.timestamps == TimestampsToReturn.Both;
        boolean sourceTimeUpdated = false;
        DateTime sourceTime = value.sourceTime();
        UShort sourcePicoseconds = value.sourcePicoseconds();
        if (!(includeSource || sourceTime == null && sourcePicoseconds == null)) {
            sourceTime = null;
            sourcePicoseconds = null;
            sourceTimeUpdated = true;
        }
        boolean serverTimeUpdated = false;
        DateTime serverTime = value.serverTime();
        UShort serverPicoseconds = value.serverPicoseconds();
        if (!(includeServer || serverTime == null && serverPicoseconds == null)) {
            serverTime = null;
            serverPicoseconds = null;
            serverTimeUpdated = true;
        } else if (includeServer && serverTime == null) {
            serverTime = DateTime.now();
            serverTimeUpdated = true;
        }
        if (sourceTimeUpdated || serverTimeUpdated) {
            value = new DataValue(value.value(), value.statusCode(), sourceTime, sourcePicoseconds, serverTime, serverPicoseconds);
        }
        return new MonitoredItemNotification(Unsigned.uint((long)this.getClientHandle()), value);
    }
}

