/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.security.cert.X509Certificate;
import org.eclipse.milo.opcua.sdk.server.identity.AbstractIdentity;
import org.eclipse.milo.opcua.sdk.server.identity.Identity;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.shaded.com.google.common.base.Objects;

public class DefaultX509UserIdentity
extends AbstractIdentity
implements Identity.X509UserIdentity {
    private final X509Certificate certificate;

    public DefaultX509UserIdentity(X509Certificate certificate) {
        this.certificate = certificate;
    }

    @Override
    public UserTokenType getUserTokenType() {
        return UserTokenType.Certificate;
    }

    @Override
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public boolean equalTo(Identity identity) {
        if (identity instanceof Identity.X509UserIdentity) {
            Identity.X509UserIdentity other = (Identity.X509UserIdentity)identity;
            return Objects.equal((Object)this.getCertificate(), (Object)other.getCertificate());
        }
        return false;
    }
}

