/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class StatusCodeConversions {
    private StatusCodeConversions() {
    }

    static @NonNull Short statusCodeToInt16(@NonNull StatusCode s) {
        return (short)(s.value() >>> 16 & 0xFFFFL);
    }

    static @NonNull Integer statusCodeToInt32(@NonNull StatusCode s) {
        return (int)s.value();
    }

    static @NonNull Long statusCodeToInt64(@NonNull StatusCode s) {
        return s.value();
    }

    static @NonNull UShort statusCodeToUInt16(@NonNull StatusCode s) {
        return Unsigned.ushort((short)StatusCodeConversions.statusCodeToInt16(s));
    }

    static @NonNull UInteger statusCodeToUInt32(@NonNull StatusCode s) {
        return Unsigned.uint((int)StatusCodeConversions.statusCodeToInt32(s));
    }

    static @NonNull ULong statusCodeToUInt64(@NonNull StatusCode s) {
        return Unsigned.ulong((long)s.value());
    }

    static @Nullable Object convert(@NonNull Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof StatusCode) {
            StatusCode s = (StatusCode)o;
            return implicit ? StatusCodeConversions.implicitConversion(s, targetType) : StatusCodeConversions.explicitConversion(s, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull StatusCode s, OpcUaDataType targetType) {
        switch (targetType) {
            case Int16: {
                return StatusCodeConversions.statusCodeToInt16(s);
            }
            case UInt16: {
                return StatusCodeConversions.statusCodeToUInt16(s);
            }
        }
        return StatusCodeConversions.implicitConversion(s, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull StatusCode s, OpcUaDataType targetType) {
        switch (targetType) {
            case Int32: {
                return StatusCodeConversions.statusCodeToInt32(s);
            }
            case Int64: {
                return StatusCodeConversions.statusCodeToInt64(s);
            }
            case UInt32: {
                return StatusCodeConversions.statusCodeToUInt32(s);
            }
            case UInt64: {
                return StatusCodeConversions.statusCodeToUInt64(s);
            }
        }
        return null;
    }
}

