/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class LocalizedTextConversions {
    private LocalizedTextConversions() {
    }

    static @Nullable String localizedTextToString(@NonNull LocalizedText text) {
        return text.text();
    }

    static @Nullable Object convert(@NonNull Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof LocalizedText) {
            LocalizedText text = (LocalizedText)o;
            return implicit ? LocalizedTextConversions.implicitConversion(text, targetType) : LocalizedTextConversions.explicitConversion(text, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull LocalizedText text, OpcUaDataType targetType) {
        return LocalizedTextConversions.implicitConversion(text, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull LocalizedText text, OpcUaDataType targetType) {
        switch (targetType) {
            case String: {
                return LocalizedTextConversions.localizedTextToString(text);
            }
        }
        return null;
    }
}

