/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class Int32Conversions {
    private Int32Conversions() {
    }

    static @NonNull Boolean int32ToBoolean(@NonNull Integer i) {
        return i != 0;
    }

    static @Nullable UByte int32ToByte(@NonNull Integer i) {
        if (i >= 0 && i <= 255) {
            return Unsigned.ubyte((int)i);
        }
        return null;
    }

    static @NonNull Double int32ToDouble(@NonNull Integer i) {
        return i.doubleValue();
    }

    static @NonNull Float int32ToFloat(@NonNull Integer i) {
        return Float.valueOf(i.floatValue());
    }

    static @Nullable Short int32ToInt16(@NonNull Integer i) {
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return i.shortValue();
        }
        return null;
    }

    static @NonNull Long int32ToInt64(@NonNull Integer i) {
        return i.longValue();
    }

    static @Nullable Byte int32ToSByte(@NonNull Integer i) {
        if (i >= -128 && i <= 127) {
            return i.byteValue();
        }
        return null;
    }

    static @NonNull StatusCode int32ToStatusCode(@NonNull Integer i) {
        return new StatusCode(i.intValue());
    }

    static @NonNull String int32ToString(@NonNull Integer i) {
        return i.toString();
    }

    static @Nullable UShort int32ToUInt16(@NonNull Integer i) {
        if (i >= 0 && i <= 65535) {
            return Unsigned.ushort((int)i);
        }
        return null;
    }

    static @Nullable UInteger int32ToUInt32(@NonNull Integer i) {
        if (i >= 0) {
            return Unsigned.uint((int)i);
        }
        return null;
    }

    static @Nullable ULong int32ToUInt64(@NonNull Integer i) {
        if (i >= 0) {
            return Unsigned.ulong((long)i.intValue());
        }
        return null;
    }

    static @Nullable Object convert(@Nullable Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return implicit ? Int32Conversions.implicitConversion(i, targetType) : Int32Conversions.explicitConversion(i, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull Integer i, OpcUaDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return Int32Conversions.int32ToBoolean(i);
            }
            case Byte: {
                return Int32Conversions.int32ToByte(i);
            }
            case Int16: {
                return Int32Conversions.int32ToInt16(i);
            }
            case SByte: {
                return Int32Conversions.int32ToSByte(i);
            }
            case StatusCode: {
                return Int32Conversions.int32ToStatusCode(i);
            }
            case String: {
                return Int32Conversions.int32ToString(i);
            }
            case UInt16: {
                return Int32Conversions.int32ToUInt16(i);
            }
            case UInt32: {
                return Int32Conversions.int32ToUInt32(i);
            }
        }
        return Int32Conversions.implicitConversion(i, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull Integer i, OpcUaDataType targetType) {
        switch (targetType) {
            case Double: {
                return Int32Conversions.int32ToDouble(i);
            }
            case Float: {
                return Int32Conversions.int32ToFloat(i);
            }
            case Int64: {
                return Int32Conversions.int32ToInt64(i);
            }
            case UInt64: {
                return Int32Conversions.int32ToUInt64(i);
            }
        }
        return null;
    }
}

